/*
  this class controls the different decoders.
  Copyright (C) 1998  Martin Vogt

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation.

  For more information look at the file COPYRIGHT in this package

 */


#include <amplifier/amplifier.h>
#include "../../../../../config.h"

Amplifier::Amplifier() {
}


Amplifier::~Amplifier() {
}


GenericPlayer* Amplifier::createPlayer(int playerType) {
  GenericPlayer* player;
  DataGenerator* generator;

  switch (playerType) {
  case _IMAGE_VIEWER: 
    generator=new ImageGenerator();
    break;
  default:
    generator=createYafGenerator(playerType);
  }
  // now we connect them:
  generator->setDecoderId(playerType);
  player=new GenericPlayer();
  player->setDataGenerator(generator);
  
  return player;
}

  


YafGenerator* Amplifier::createYafGenerator(int playerType) {
  int argn;
  AmplifierConfig* config=new AmplifierConfig();
  YafGenerator* generator=new YafGenerator();
  char** args=config->getExecutable(playerType);

  argn=0;
  while(1) {
    if ((*args)==NULL) {
      break;
    }
    generator->addArgument((*args));
    argn++;
    args++;
  }
  if (argn == 0) {
    debugOutput( cout << "No executable for type : " << playerType << "registered !"<<endl );
    return NULL;
  }
  generator->startDecoder();
  // now we connect them:
  delete config;
  return generator;
}








    

  
