/*
  Copyright (C) 1999 Rainer Maximini

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation.

  For more information look at the file COPYRIGHT in this package
*/

#ifndef SONGINFO_H
#define SONGINFO_H

#include <kapp.h>
#include <kconfig.h>
#include <kcombo.h>
#include <klined.h>
#include <qstring.h>
#include <qwidget.h>
#include <qdialog.h>
#include <qlabel.h>
#include <qpushbutton.h>
#include <qgroupbox.h>
#include <klined.h>
#include "kjukebox.h"
#include "mp3.h"

class SongInfo: public QDialog {
    Q_OBJECT     
 private:    
    QPushButton *applyButton;
    QPushButton *acceptButton;
    QPushButton *cancelButton;
    Song       songCopy;
    Song      *songReference;
    QGroupBox *boxTag;
    QGroupBox *boxLayer;
    QGroupBox *boxPrivate;

    QLabel *catTitle;
    QLineEdit *valueTitle;
    QLabel *catArtist;
    QLineEdit *valueArtist;
    QLabel *catAlbum;
    QLineEdit *valueAlbum;
    QLabel *catYear;
    QLineEdit *valueYear;   
    QLabel *catComment;
    QLineEdit  *valueComment;
    QLabel *catGenre;
    KCombo *valueGenre;

    QLabel *catTime, *valueTime;
    QLabel *catSize, *valueSize;
    QLabel *catPath, *valuePath;
    QLabel *catFilename, *valueFilename;
    QLabel *catSamplerate, *valueSamplerate;
    QLabel *catBitrate, *valueBitrate;
    QLabel *catStereo, *valueStereo;
    QLabel *catLayer, *valueLayer;
    QLabel *catPlayed, *valuePlayed;
    QLabel *catLastPlayed, *valueLastPlayed;
    QLabel *catFirstSeconds;
    QLabel *catLastSeconds;
    QLineEdit *valueLastSeconds;
    QLineEdit *valueFirstSeconds;

    KConfig *config;
    MP3 mp3;
    
    void resizeEvent( QResizeEvent * );    
    void showSong();
    bool saveComment();
    void setGenreBox();

 public:
    SongInfo(QWidget *parent=0, const char *name=0);    
    void showMP3Song(Song *);
    
 public slots:
    void closeWindow();
    void referenceChanged(Song *oldRef, Song *newRef);
    void referenceRemoved(Song *song);
    void songRemoved();

 private slots:
    void accept();
    void apply();

 signals:
    void songChanged(Song *);
};


#endif // SONGINFO_H
