/*
  a class for led digits
  Copyright (C) 1998  Martin Vogt & Rainer Maximini

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation.

  For more information look at the file COPYRIGHT in this package

 */



#include "lcdBitmap.h"


LCDBitmap::LCDBitmap() {

#include "lcdPixmaps.h" /* the bitmaps as XPM format */

  pixmapArray[_LCD_DIGIT_0] = new QPixmap(digit_0);
  pixmapArray[_LCD_DIGIT_1] = new QPixmap(digit_1);
  pixmapArray[_LCD_DIGIT_2] = new QPixmap(digit_2);
  pixmapArray[_LCD_DIGIT_3] = new QPixmap(digit_3);
  pixmapArray[_LCD_DIGIT_4] = new QPixmap(digit_4);
  pixmapArray[_LCD_DIGIT_5] = new QPixmap(digit_5);
  pixmapArray[_LCD_DIGIT_6] = new QPixmap(digit_6);
  pixmapArray[_LCD_DIGIT_7] = new QPixmap(digit_7);
  pixmapArray[_LCD_DIGIT_8] = new QPixmap(digit_8);
  pixmapArray[_LCD_DIGIT_9] = new QPixmap(digit_9);

  pixmapArray[_LCD_PANEL] = new QPixmap(panel);
  pixmapArray[_LCD_DOTS ] = new QPixmap(points);
  pixmapArray[_LCD_BLANK] = new QPixmap(digit_blank);
  pixmapArray[_LCD_PAUSE] = new QPixmap(digit_pause);
  pixmapArray[_LCD_PLAY ] = new QPixmap(digit_play);
  pixmapArray[_LCD_MINUS] = new QPixmap(digit_minus);
  pixmapArray[_LCD_STOP ] = new QPixmap(digit_stop);

  pixmapArray[_LCD_COL_RIGHT] = new QPixmap(col_right);
  pixmapArray[_LCD_A] = new QPixmap(bst_A);
  pixmapArray[_LCD_B] = new QPixmap(bst_B);
  pixmapArray[_LCD_C] = new QPixmap(bst_C);
  pixmapArray[_LCD_D] = new QPixmap(bst_D);
  pixmapArray[_LCD_E] = new QPixmap(bst_E);
  pixmapArray[_LCD_F] = new QPixmap(bst_F);

}


LCDBitmap::~LCDBitmap() {
  for(int i=0;i<_LCD_ELEMENTS;i++) 
    delete pixmapArray[i];
}


QPixmap* LCDBitmap::getPixmap(int type) {
  if ((type < 0) || (type > _LCD_ELEMENTS)) {
    type=0; /* Not a legal type, use the default */
  }
  return pixmapArray[type];
}

