/*
  Copyright (C) 1999 Rainer Maximini

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation.

  For more information look at the file COPYRIGHT in this package
*/


#ifndef JUMPDEVICE_H
#define JUMPDEVICE_H


#include <qslider.h>
#include <devices/audioStreamInfoDevice.h>


class JumpDevice : public QSlider{
  Q_OBJECT    
 private:
  AudioStreamInfoDevice* streamInfoDevice;
  bool receiveEvents;
  bool updateSlider;
  int len;  
  int status;

 public:
  JumpDevice(QWidget *parent=0, const char *name=0);
  ~JumpDevice();
  void attachTo(AudioStreamInfoDevice* streamInfoDevice);
  void detach();

 protected slots:
  void processEvent(char eventId);
  void resizeEvent(QResizeEvent *);

 public slots:
  void enableEvents(); 
  void disableEvents();

 signals:
  void jump(int seconds);
};

#endif // JUMPDEVICE
