/*
  Copyright (C) 1999 Rainer Maximini

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation.

  For more information look at the file COPYRIGHT in this package
*/

#ifndef ALARMTIMER_H
#define ALARMTIMER_H

#include <qobject.h>
#include <devices/audioStreamInfoDevice.h>

#define _TIMEMODE_PLAYED             100
#define _TIMEMODE_REMAIN             101     


class AlarmTimer : public QObject{
  Q_OBJECT
 private:
  int  alarmTime;
  int  timerId;
  AudioStreamInfoDevice* streamInfoDevice;

  void checkAlarmTime();
  void startAlarmTimer();
  void stopAlarmTimer();


 protected:
  void timerEvent( QTimerEvent * );

 public:
  AlarmTimer(QObject *parent=0, const char *name=0);
  ~AlarmTimer();
  void attachTo(AudioStreamInfoDevice* streamInfoDevice);
  void detach();

 signals:
  void alarm();

 private slots:
  void processEvent(char eventId);

 public slots:
  void setAlarmTime(int seconds);
  void clearAlarmTime();
};


#endif ALARMTIMER_H



