//
//
//    guitune - program for tuning instruments (actually an oscilloscope)
//    Copyright (C) 1999  Florian Berger
//    Email: florian.berger@jk.uni-linz.ac.at
//
//    This program is free software; you can redistribute it and/or modify
//    it under the terms of the GNU General Public License Version 2 as
//    published by the Free Software Foundation;
//
//    This program is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with this program; if not, write to the Free Software
//    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//
//

//#include <iostream.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <sys/ioctl.h>
#include <linux/soundcard.h>


#include <unistd.h>
#include <stdio.h>
#include <time.h>
#include <stdlib.h>
#include <string.h>


#include <qapplication.h>
#include <qwidget.h>
#include <qpainter.h>
#include <qfile.h>
#include <qfiledialog.h>
#include <qmenubar.h>
#include <qpopupmenu.h>
#include <qscrollbar.h>
#include <qkeycode.h>
#include <qlineedit.h>
#include <qpushbutton.h>
#include <qimage.h>
#include <qtimer.h>
#include <qlcdnumber.h>
#include <qspinbox.h>
#include <qmainwindow.h>


#include <math.h>

#include "osziview.h"
#include "logview.h"
#include "guitune.h"

#include "resources.h"



//globally
double KAMMERTON, KAMMERTON_LOG;



int close_unistd(int fd){ return( close(fd) ); }
// unistd - close is not visible to widget because of own close function


void MainWidget::setTuningNorm()
{
    KAMMERTON=KAMMERTON_NORM;
    KAMMERTON_LOG=KAMMERTON_LOG_NORM;
    update();
}

void MainWidget::setTuningWien()
{
    KAMMERTON=KAMMERTON_WIEN;
    KAMMERTON_LOG=KAMMERTON_LOG_WIEN;
    update();
}

void MainWidget::setTuningPhys()
{
    KAMMERTON=KAMMERTON_PHYS;
    KAMMERTON_LOG=KAMMERTON_LOG_PHYS;
    update();
}


void MainWidget::setTuningEqui()
{
    logview->nat_tuning_on=false;
    update();
}


void MainWidget::setTuningNat()
{
    logview->nat_tuning_on=true;
    update();
}


void MainWidget::setScaleUS()
{
    logview->setScale(LogView::us_scale);
}

void MainWidget::setScaleUSAlt()
{
    logview->setScale(LogView::us_scale_alt);
}

void MainWidget::setScaleGE()
{
    logview->setScale(LogView::german_scale);
}

void MainWidget::setScaleGEAlt()
{
    logview->setScale(LogView::german_scale_alt);
}



void MainWidget::showLogView()
{
 	  logview->show();
}

void MainWidget::hideLogView()
{
 	  logview->hide();
}

void MainWidget::showOszi()
{
 	  oszi->show();
}

void MainWidget::hideOszi()
{
 	  oszi->hide();
}

double MainWidget::getTrigger()
{
 	  return(oszi->getTrigFact());
}

void MainWidget::setSampFreq(int f)
{
    sampfreq = f;
    timer->stop();
    close_unistd(audio);
    audio=init_audio();
    timer->start(0);
    oszi->setSampleFreq(sampfreq_exact);
    emit signalSampFreqChanged();
}


void MainWidget::setSampNr(int nr)
{
    sampnr=nr;
    oszi->setSampleNr(nr);
    emit signalSampNrChanged();
}


void MainWidget::setTrigger(double trig)
{
    oszi->setTrigFact(trig);
    emit signalTriggerChanged();
}


void MainWidget::setTriggerPercent(int trig)
{
    setTrigger((double)trig/100.0);
}

void MainWidget::setDSPName(const char *name)
{
    timer->stop();
    close_unistd(audio);
    strcpy(dsp_devicename,name);
    audio=init_audio();
    timer->start(0);
}

int MainWidget::init_audio()
{
// int audio_fd;

   printf("initializing audio at %s\n",dsp_devicename);

   audio = open(dsp_devicename, O_RDONLY);
   if (audio == -1) {
      perror(dsp_devicename);
      exit(1);
   }
   fcntl(audio,F_SETFD,FD_CLOEXEC);

//   ioctl(audio, SNDCTL_DSP_RESET, 0);
   if( strcmp(dsp_devicename,"/dev/stdin")==0 ){

      printf("reading data fronm stdin\n");
   		blksize=32;
      printf("  blocksize=%d\n",blksize);
      printf("  sampfreq=%d\n",sampfreq);
      sampfreq_exact=sampfreq;

   }else{

      ioctl(audio, SNDCTL_DSP_SETDUPLEX, 0);

      {int caps;
          ioctl( audio, SNDCTL_DSP_GETCAPS, &caps );
          printf("OSS-Version %d\n", caps & DSP_CAP_REVISION );
       		printf("  DUPLEX   = %X\n",caps & DSP_CAP_DUPLEX   );
          printf("  REALTIME = %X\n",caps & DSP_CAP_REALTIME );
          printf("  BATCH    = %X\n",caps & DSP_CAP_BATCH    );
          printf("  COPROC   = %X\n",caps & DSP_CAP_COPROC   );
          printf("  TRIGGER  = %X\n",caps & DSP_CAP_TRIGGER  );
          printf("  MMAP     = %X\n",caps & DSP_CAP_MMAP     );
   		}

   		blksize=4;  // 2^4 = 16
  		ioctl(audio, SNDCTL_DSP_SETFRAGMENT, &blksize);
//   ioctl(audio, SNDCTL_DSP_SETBLKSIZE, &blksize);

      ioctl(audio, SNDCTL_DSP_GETBLKSIZE, &blksize);
      printf("blocksize=%d\n",blksize);
   //blksize=4096;

      ioctl(audio, SNDCTL_DSP_SYNC, NULL);
//   int a_sampsize = 8;
      int a_sampsize = AFMT_U8;
      ioctl(audio, SNDCTL_DSP_SAMPLESIZE, &a_sampsize);
      int a_stereo = 0;
      ioctl(audio, SNDCTL_DSP_STEREO, &a_stereo);

      int a_speed = sampfreq;
      printf("sampfreq=%d\n",sampfreq);
      ioctl(audio, SNDCTL_DSP_SPEED, &a_speed);
      ioctl(audio, SOUND_PCM_READ_RATE, &sampfreq);
      printf("sampfreq=%d\n",sampfreq);
      sampfreq_exact=sampfreq;

   }

   //int mixer = open("/dev/mixer", O_RDONLY, 0);
   //int vol=0xFFFF;
   //ioctl(mixer, SOUND_MIXER_WRITE_MIC, &vol);
   //printf("MIC-Volume=%d\n",vol);
   //close(mixer);

// printf("close(audio)=%d\n",close(audio));
// printf("close(audio)=%d\n",close(audio));

   return(audio);
}




MainWidget::MainWidget( QWidget *parent, const char *name, int argc, char **argv )
               : QWidget(parent,name)
{int i;
   //InitAudio();
//   setMinimumSize(490,240);

   KAMMERTON=KAMMERTON_NORM;
   KAMMERTON_LOG=KAMMERTON_LOG_NORM;

   strcpy(dsp_devicename,"/dev/dsp");

   sampnr=1024;
   sampfreq=11048;
   processing_audio=0;
   audio = init_audio();
   printf("Audiodriver initialized\n");

   freqs[0]=KAMMERTON; lfreqs[0]=KAMMERTON_LOG;
   for(i=1;i<12;i++){
      freqs [i] = freqs [i-1] * D_NOTE;
      lfreqs[i] = lfreqs[i-1] + D_NOTE_LOG;
   }
/*   filemenu = new QPopupMenu( this,"file_menu" );
   filemenu->setFont( QFont("OldEnglish") );
   filemenu->insertItem( "&Open", this, SLOT( mfile_open() ) );
   filemenu->insertItem( "&Save", this, SLOT( mfile_save() ) );
   filemenu->insertItem( "E&xit", qApp, SLOT( quit() ), ALT+Key_X );
   optmenu = new QPopupMenu( this,"options_menu" );
   optmenu->setFont( QFont("OldEnglish") );
   optmenu->insertItem( "Set Sample&freq", this, SLOT( mopt_setsfreq() ) );
   viewmenu = new QPopupMenu( this,"view_menu" );
   viewmenu->setFont( QFont("OldEnglish") );
   viewmenu->insertItem( "&Oszi", this, SLOT( mview_oszi() ) );
   viewmenu->insertItem( "&Tone Scale", this, SLOT( mview_tonesc() ) );
   viewmenu->setCheckable( TRUE );
   menu = new QMenuBar( this, "menu_bar" );
   menu->setFont( QFont("OldEnglish") );
   menu->insertItem( "&File", filemenu );
   menu->insertItem( "&Options", optmenu );
   menu->insertItem( "&View", viewmenu );*/
   oszi = new OsziView( this, "oszi_name" );
//   oszi->setGeometry(0,0,400,150);
   oszi->setSampleNr( sampnr );
   oszi->setSampleFreq(sampfreq_exact);
   logview = new LogView( this, "logview_name" );
   logview->setFrameStyle( QFrame::Box | QFrame::Sunken );
   logview->setLineWidth( 2 );
//   logview->setGeometry(0,oszi->height(),width(),80);
   QColorGroup cg(qRgb(0xFF,0,0),qRgb(0,0,0),qRgb(0xFF,0x88,0x88),qRgb(0x88,0,0),qRgb(0xFF,0,0),qRgb(0xFF,0xFF,0xFF),qRgb(0x88,0x88,0x88));
   QPalette pal(cg,cg,cg);
   freqview = new QLCDNumber( this, "freqview_name");
   freqview->setNumDigits(9);
   freqview->setFrameStyle(QFrame::NoFrame);
   freqview->setSegmentStyle(QLCDNumber::Filled);
   freqview->setPalette(pal);
   nfreqview = new QLCDNumber( this, "nfreqview_name");
   nfreqview->setNumDigits(9);
   nfreqview->setFrameStyle(QFrame::NoFrame);
   nfreqview->setSegmentStyle(QLCDNumber::Filled);
   nfreqview->setPalette(pal);
//   freqview->setSegmentStyle(QLCDNumber::Filled);
   sampfreq_input = new QSpinBox( 1000, 44000, 50, this );
//   sampfreq_input -> setGeometry( freqview->x()+freqview->width()+30,
//                                  logview->y()+logview->height()+20,
//                                  70,20 );
   sampfreq_input -> setValue(sampfreq);
   connect( sampfreq_input, SIGNAL(valueChanged(int)),
            this,           SLOT(setSampFreq(int))     );
   sampnr_input = new QSpinBox( 32, 11048, 32, this );
//   sampnr_input -> setGeometry( sampfreq_input->x(),
//                                sampfreq_input->y()+
//                                sampfreq_input->height()+10,  70,20 );
   sampnr_input -> setValue(sampnr);
   connect( sampnr_input, SIGNAL(valueChanged(int)),
            this,         SLOT(setSampNr(int))   );
   trigger_input = new QSpinBox( 0, 100, 10, this );
   trigger_input -> setValue((int)(getTrigger()*100.0+0.5));
   connect( trigger_input, SIGNAL(valueChanged(int)),
            this,          SLOT(setTriggerPercent(int))  );
   timer = new QTimer(this);
   connect(  timer, SIGNAL(timeout()), this, SLOT(proc_audio()) );
   timer->start(0);
}



void MainWidget::proc_audio()
{int i,j,n,trig,trigpos;
 static int k=0;
 unsigned char *c;
 double ldf,mldf;
 char str[50];
   processing_audio=1;
   trigpos=0;
   c=sample; n=0;
   n = read(audio, c, blksize);
   for( i=0; i<n && Abs(c[i]-128)<2; i++ );
   //i=-1;
   j=0; trig=0;
   if (i<n) do {
      n = read(audio, c, blksize);
      for( i=0; i<n-1; i++ )
				 if ( POSTRIG(c,i) ) { trig=1; trigpos=i; }
			j++;
   }while( (!trig) && j<100 );
//   else printf("No Signal %d\n",blksize);
   if( trig ){
      for( i=1; i<(sampnr/blksize+1); i++ ){
         c+=n;
         n = read(audio, c, blksize);
      }
//      oszi->setSampleFreq( sampfreq_exact );
      oszi->setSamplePtr( &sample[trigpos] );
//      oszi->setSampleNr( sampnr );
      oszi->paintSample();
      freq_0t = (double)sampfreq*oszi->getfreq2();
      lfreq_0t = log(freq_0t);
      while ( lfreq_0t < lfreqs[0]-D_NOTE_LOG/2.0 ) lfreq_0t+=LOG_2;
      while ( lfreq_0t >= lfreqs[0]+LOG_2-D_NOTE_LOG/2.0 ) lfreq_0t-=LOG_2;
      mldf=D_NOTE_LOG; note_0t=0;
      for( i=0; i<12; i++ ){
				 ldf = fabs(lfreq_0t-lfreqs[i]);
				 if (ldf<mldf) { mldf=ldf; note_0t=i; }
      }
      logview->change_lfreq(lfreq_0t);
      sprintf(str,"%.3f",freq_0t);
      freqview->display(str);
      double nfreq_0t=freqs[note_0t];
      while( nfreq_0t/freq_0t > D_NOTE_SQRT ) nfreq_0t/=2.0;
      while( freq_0t/nfreq_0t > D_NOTE_SQRT ) nfreq_0t*=2.0;
      sprintf(str,"%.3f",nfreq_0t);
      nfreqview->display(str);
//      printf("Note: %s (%lfHz) Freq=%lf\n",
//	        note[note_0t],freqs[note_0t],freq_0t);
   }
   k++;
   processing_audio=0;
}



void MainWidget::paintEvent( QPaintEvent * )
{

	 QPainter p(this);

     p.setFont(QFont("System",8));
     p.setPen( qRgb(0xFF,0xFF,0xFF) );
	   p.drawText( freqview->x()-p.fontMetrics().width("Freq.:")-5+1,
	  	           freqview->y()+p.fontMetrics().ascent()+1
			           +p.fontMetrics().height(), "Freq.:" );
     p.setPen( qRgb(0,0,0) );
	   p.drawText( freqview->x()-p.fontMetrics().width("Freq.:")-5,
	  	           freqview->y()+p.fontMetrics().ascent()
			           +p.fontMetrics().height(), "Freq.:" );

     p.setPen( qRgb(0xFF,0xFF,0xFF) );
	   p.drawText( nfreqview->x()-p.fontMetrics().width("Note:")-5+1,
	  	           nfreqview->y()+p.fontMetrics().ascent()+1
			           +p.fontMetrics().height(), "Note:" );
     p.setPen( qRgb(0,0,0) );
	   p.drawText( nfreqview->x()-p.fontMetrics().width("Note:")-5,
	  	           nfreqview->y()+p.fontMetrics().ascent()
			           +p.fontMetrics().height(), "Note:" );

     p.setPen( qRgb(0xFF,0xFF,0xFF) );
	   p.drawText( sampfreq_input->x()-p.fontMetrics().width("Sample Freq.:")-5+1,
	  	           sampfreq_input->y()+p.fontMetrics().ascent()+1
			           +p.fontMetrics().height()-3, "Sample Freq.:" );
     p.setPen( qRgb(0,0,0) );
	   p.drawText( sampfreq_input->x()-p.fontMetrics().width("Sample Freq.:")-5,
	  	           sampfreq_input->y()+p.fontMetrics().ascent()
			           +p.fontMetrics().height()-3, "Sample Freq.:" );

     p.setPen( qRgb(0xFF,0xFF,0xFF) );
	   p.drawText( sampnr_input->x()-p.fontMetrics().width("Sample #:")-5+1,
	  	           sampnr_input->y()+p.fontMetrics().ascent()+1
			           +p.fontMetrics().height()-3, "Sample #:" );
     p.setPen( qRgb(0,0,0) );
	   p.drawText( sampnr_input->x()-p.fontMetrics().width("Sample #:")-5,
	  	           sampnr_input->y()+p.fontMetrics().ascent()
			           +p.fontMetrics().height()-3, "Sample #:" );

     p.setPen( qRgb(0xFF,0xFF,0xFF) );
	   p.drawText( trigger_input->x()-p.fontMetrics().width("Trig.(% of max):")-5+1,
	  	           trigger_input->y()+p.fontMetrics().ascent()+1
			           +p.fontMetrics().height()-3, "Trig.(% of max):" );
     p.setPen( qRgb(0,0,0) );
	   p.drawText( trigger_input->x()-p.fontMetrics().width("Trig.(% of max):")-5,
	  	           trigger_input->y()+p.fontMetrics().ascent()
			           +p.fontMetrics().height()-3, "Trig.(% of max):" );
   p.end();

//   oszi->repaint();
   logview->update();
}


void MainWidget::resizeEvent( QResizeEvent * )
{
   int fwidth;
   fwidth=150;
   oszi->setGeometry( 0, 0, width()-fwidth, height()-100 );
   logview->setGeometry( 0, (oszi->isVisible())?oszi->height():0, width(), 100 );
//   freqview->setGeometry( width()-fwidth, ((oszi->isVisible())?oszi->height():0)+((logview->isVisible())?logview->height():0), 150, 30 );
//   nfreqview->setGeometry( width()-fwidth, ((oszi->isVisible())?oszi->height():0)+((logview->isVisible())?logview->height():0)+40, 150, 30 );
   freqview->setGeometry( width()-fwidth+40, 3, 100, 25 );
   nfreqview->setGeometry( width()-fwidth+40, 35, 100, 25 );
   sampfreq_input -> setGeometry( width()-80,65,70,20 );
   sampnr_input -> setGeometry( sampfreq_input->x(),
                                sampfreq_input->y()+
                                sampfreq_input->height()+5,  70,20 );
   trigger_input -> setGeometry( sampnr_input->x()+20,
                                 sampnr_input->y()+
                                 sampnr_input->height()+5,  50,20 );
}


MainWidget::~MainWidget()
{
//   delete oszi;
   close_unistd(audio);
}


//#include"moc_guitune.cpp"










































































