/* Dies ist unsere Kradio Klasse, sie verkrpert nur unsere
 * Oberflche 
 * Written Nov 1998 Carsten Gro (carsten@sol.wohnheim.uni-ulm.de)
 * Orientiert sich ein bichen an kexample von Matthias Ettrich
 */

/** 
 * Die Stationsdialogklasse
 * 
 */

#include "stationsdialog.h"
#include "radioctrl.h"
#include "kderadio.h"
#include <iostream.h>
#include <assert.h>

StationsDialog::StationsDialog(QWidget *parent, const char *name, \
	double tunedfreq) : QDialog(parent, name, TRUE) {

	// TODO: Die hartcodierten.. jaja
	strcpy(Station, "\0");
	pOk = new QPushButton(i18n("OK"), this, 0);
	pCancel = new QPushButton(i18n("Cancel"), this, 0);
	pGroupBox = new QGroupBox(i18n("Enter new station"), this, 0);
	
	QString a;
	a.setNum(tunedfreq, 'f', 2);
	a = a + "MHz"; 
	pFrequenzAnzeige = new QLabel(a, pGroupBox, 0, 0);
	pStationsAnzeige = new QLineEdit(pGroupBox, 0);

	/* Size Hints auswerten und dialog einstellen */
	int distanz = 20;

	pOk->resize(pOk->sizeHint());
	pCancel->resize(pCancel->sizeHint());
	pFrequenzAnzeige->resize(pFrequenzAnzeige->sizeHint());
	pStationsAnzeige->resize(pStationsAnzeige->sizeHint());
	
	pGroupBox->resize(2*distanz + pStationsAnzeige->width(), \
		2 * distanz + 10 + pStationsAnzeige->height() \
		+ pFrequenzAnzeige->height());
	pFrequenzAnzeige->move(distanz, distanz);
	pStationsAnzeige->move(distanz, (distanz/2) + distanz +\
		 pFrequenzAnzeige->height());
	pGroupBox->move(distanz, distanz);
	pOk->move(distanz, pGroupBox->height() + 2 *distanz);
	pCancel->move(2*distanz+pOk->width(), pGroupBox->height() + \
		2*distanz);
	int xsize=2*distanz+pOk->width()+pCancel->width()+distanz;
	int xsize2=2*distanz+pGroupBox->width();
	if (xsize2>xsize) { xsize = xsize2; }
	int ysize=3*distanz+pOk->height()+pGroupBox->height();
	this->resize(xsize, ysize);
	connect(pStationsAnzeige, SIGNAL( textChanged(const char *) ), \
		this, SLOT( slotChangeText (const char *) ));
	connect(pStationsAnzeige, SIGNAL( returnPressed() ), \
		this, SLOT( accept() ));


	connect(pOk, SIGNAL(clicked() ), SLOT( accept()));
	connect(pCancel, SIGNAL(clicked() ), SLOT(reject()));
}

char * StationsDialog::getStation(void) {
	if (strlen(Station)<1) {
#ifndef NDEBUG
		cerr << "Gebe NULL in getStation zurck\n";
#endif
		return 0;
	} 
	return Station;
}

void   StationsDialog::slotChangeText( const char * text) {
	snprintf(Station, 40, "%s", text);
	return;
}

void StationsDialog::accept() {
	done(TRUE);
}
