/*
 *              KDERadio - Ein Radio fr KDE
 *
 * (C) Siehe docking.cpp file
 */


#ifndef _DOCKING_H_
#define _DOCKING_H_

#include <stdio.h>
#include <qapp.h>
#include <qpixmap.h>
#include <qtimer.h>
#include <qpopmenu.h>
#include <qpoint.h>
#include "kderadio.h"


class DockWidget : public QWidget {

  Q_OBJECT

public:
  DockWidget(class KRadio *, const char *name=0);
  ~DockWidget();

protected:
  void paintEvent(QPaintEvent *e);

private slots:
    void toggle_window_state();
    void timeclick();
    void mousePressEvent(QMouseEvent *e);

public slots:
    void dock();
    void undock();
    void paintIcon();
    void slotIncreaseStation(void);
    void slotDecreaseStation(void);

public:
    const bool isDocked();
    const bool isToggled();
    void SaveKDERadioPosition();

private:
  class KRadio *pkderadio;
  bool docked;
  int toggleID;
  int pos_x;
  int pos_y;
  QPopupMenu *popup_m;
  bool HaveKDERadioPosition;
  QPixmap miniKDERadioPixmap;
  bool toggled;

};

#endif
