/***************************************************************************
                          encoder.h  -  description                              
                             -------------------                                         
    begin                : Wed Apr 14 1999                                           
    copyright            : (C) 1999 by ROLLY Arnaud                         
    email                : rolly@technologist.com                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#ifndef ENCODER_H
#define ENCODER_H

#include "kblade.h"

#include <qdialog.h>
#include <qlist.h>
#include <qstring.h>
#include <qlabel.h>
#include <qtimer.h>
#include <kprocess.h>
#include <qprogressbar.h>
#include <qpushbutton.h>

#include <list>

/**
  *@author ROLLY Arnaud
  */

class Encoder : public QDialog  {
   Q_OBJECT
public: 
	Encoder(KBlade *blade, QWidget *parent=0, const char *name=0);
	~Encoder();
protected:
	KBlade *kblade;
	int lastEncodedFile;
	QLabel *wav, *mp3;
	QTimer *go;
	QPushButton *mainBtn;
	KProcess *p;
	QProgressBar *bar;
	void convert(QString &inFile);
	void encodeNewFile();
protected slots:
	void slotEncode();
	void slotCancel();
	void slotBladeEncStdOut(KProcess *proc, char *buffer, int len);
	void slotBladeEncStdErr(KProcess *proc, char *buffer, int len);
	void slotEncodeNewFile(KProcess *);
};

#endif





















