    /*

    Copyright (C) 1999 Stefan Westerfeld
                       stefan@space.twc.de

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    */

#ifndef __MBROKER_IMPL_H__
#define __MBROKER_IMPL_H__

#include "arts.h"
#include "artsobject.h"

class MB_ServerEntry {
public:
	Arts::ModuleInfo *info;
	Arts::ArtsServer_var server;

	MB_ServerEntry(Arts::ArtsServer *server, Arts::ModuleInfo *info);
};

// Implementation for interface ModuleBroker
class ModuleBroker_impl : 
  virtual public ArtsObject_impl,
  virtual public Arts::ModuleBroker_skel
{
  protected:
	list<MB_ServerEntry *> infolist;
	CORBA::Long nextID;
	CORBA::Long _updateCount;
	Arts::Synthesizer_var Synthesizer;
	list<string> paths;

  public:
    Arts::StringSeq* publishedModules();
	CORBA::Long updateCount();

    void publishModule(Arts::ArtsServer *server, const Arts::ModuleInfo& info);
    Arts::ModuleInfo* lookupModule(const char* name);
    void removeModule(Arts::ArtsServer *server, const char* name);
    void serverShutdown(Arts::ArtsServer *server);
	Arts::ArtsServerSeq* whichServerProvides(const char *name);
	CORBA::Long mkID();

	void addPublishingPath(const char *path);
	void loadStructure(const char *name);

	ModuleBroker_impl(Arts::Synthesizer_ptr Synthesizer);
};


#endif
