	/*

	Copyright (C) 1998-1999 Stefan Westerfeld
                            stefan@space.twc.de

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    */

#include "synthmodule.h"
#include "synth_impl.h"
#include "debug.h"
#include "arts.h"

class BusClient
{
public:
	virtual void
		configureBus(list<BusClient *>& clientlist, unsigned long channels)
		{ /* only in downlinks */ }
	virtual SynthModule *Module() = 0;
};


class BusManager
{
	struct Bus
	{
		string name;
		list<BusClient *> clients;
		list<BusClient *> servers;
	};
	list<Bus *> BusList;

	BusManager();

public:
	Bus* findBus(string name);
	void reBuild(Bus *bus);
	void erase(BusClient *busclient);
	void addClient(string busname, BusClient *client);
	void removeClient(BusClient *client);
	void addServer(string busname, BusClient *server);
	void removeServer(BusClient *server);

	Arts::StringSeq *busList();

	static BusManager *the();
};
