    /*

    Copyright (C) 1999 Stefan Westerfeld
                       stefan@space.twc.de

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    */

#ifndef __STRUCTURE_H_
#define __STRUCTURE_H_

#include "arts.h"
#include "module.h"
#include "scomponent.h"
#include "structureport.h"

class ExecutableStructure {
protected:
	Arts::Synthesizer *Synthesizer;
	long execID;

public:
	ExecutableStructure(Arts::Synthesizer *Synthesizer);
	virtual ~ExecutableStructure();

	virtual void startExecute(const Arts::ArtsServerSeq& preferredservers) = 0;
	virtual void stopExecute();
	virtual bool isExecuting();
	virtual bool saveSession(const char *filename);
};

class Structure :public ExecutableStructure
{
	Arts::StructureDesc_var StructureDesc;
	StructureCanvas *canvas;

	list<Module *> ModuleList;
	list<StructureComponent *> ComponentList;

public:
	Structure(Arts::Synthesizer *Synthesizer);
	~Structure();

	void setCanvas(StructureCanvas *canvas);

	void startExecute(const Arts::ArtsServerSeq& preferredservers);

	bool valid();
	void load(const char *filename);
	void retrieve(const char *pubname);
	void loadFromList(Arts::StringSeq *strseq);
	void save(const char *filename);
	void clear();
	void publish();

	long countSelected();
	void deleteSelected();

	char *name();
	void rename(const char *newname);

	Module *createModule(const Arts::ModuleInfo *minfo);
	StructurePort *createStructurePort(const Arts::PortType type);

	StructureComponent *componentAt(long x, long y, bool ignore_selected);

	list<Module *> *getModuleList();
	list<StructureComponent *> *getComponentList();
};

#endif
