    /*

    Copyright (C) 1999 Stefan Westerfeld
                       stefan@space.twc.de

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    */

#include "guipanel.h"
#include "qframe.h"
#include "kiconloader.h"

static long instances = 0;

Gui_PANEL::Gui_PANEL()
{
	Widget = 0;
	ParentWidget = 0;
	instances++;
	printf("NOW %ld instances of the panel active\n",instances);
}

Gui_PANEL::~Gui_PANEL()
{
	if(Widget) delete Widget;
	instances--;
	printf("NOW %ld instances of the panel active\n",instances);
}

void Gui_PANEL::widgetDestroyed(QWidget *widget)
{
	assert(Widget == widget);
	Widget = 0;
}

void Gui_PANEL::publish(Arts::ArtsServer *Server, Arts::ModuleBroker *Broker)
{
	Arts::ModuleInfo info;

	info.name = CORBA::string_dup("Gui_PANEL");
	info.isInterface = false;
	info.isStructure = false;

	addPort(info,"width",Arts::input,Arts::audio_data,Arts::property);
	addPort(info,"height",Arts::input,Arts::audio_data,Arts::property);
	addPort(info,"pixmap",Arts::input,Arts::string_data,Arts::property);
	addPort(info,"id",Arts::output,Arts::audio_data,Arts::stream);

	Broker->publishModule(Server, info);
}

void *Gui_PANEL::Creator()
{
	return new Gui_PANEL;
}

ModuleClient MC_Gui_PANEL(GuiModule::get_MS,"Gui_PANEL",Gui_PANEL::Creator);

void Gui_PANEL::applyParameters(Arts::ModuleDesc *desc)
{
	printf("crw\n");
	if(!Widget)
	{
		QFrame *Frame = new QFrame();
		Frame->setFrameStyle( QFrame::Panel | QFrame::Raised );
		Frame->setLineWidth( 2 );
		Widget = Frame;
		watchWidget(Widget);
	}

	int width,height;
	printf("sfs\n");

	getSize(desc,width,height);
	Widget->setFixedSize(width,height);

	string bg = getStringParam(desc,"pixmap");
	if(strlen(bg.c_str()))
	{
		KIconLoader iconloader;
		QString iconname = QString(bg.c_str())+".xpm";
		QPixmap *pixmap = new QPixmap(iconloader.loadIcon(iconname));

		if(!pixmap->height())
		{
			delete pixmap;
			pixmap = 0;
		}
		else
		{
			Widget->setBackgroundPixmap(*pixmap);
		}
	}
	idPort = lookupPort(desc,"id");
}

QWidget *Gui_PANEL::isParent()
{
	return(Widget);
}

void Gui_PANEL::setParent(QWidget *parent, QBoxLayout *layout)
{
	if(Widget)
	{
		printf("recreating widget...\n");
		Widget->recreate(parent,0,QPoint(0,0));
		if(layout)
		{
			printf("adding widget to layout\n");
			layout->addWidget(Widget);
		}
		printf("ok.\n");
	}
	ParentWidget = parent;
}

void Gui_PANEL::finalize()
{
	emitSignal(idPort,(float)_GlobalID);
}

void Gui_PANEL::start()
{
	Widget->show();
}
