    /*

    Copyright (C) 1999 Stefan Westerfeld
                       stefan@space.twc.de

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    */

#ifndef __STRUCTBUILDER_H__
#define __STRUCTBUILDER_H__

#include "arts.h"
#include <list>

/*
 * StructureBuilder
 *
 * This class is a wrapper around the operations necessary for creating
 * structures. So this is meant for convenience. (export as CORBA?)
 *
 * currently missing: preferredServers handling
 * 
 * ignored: visual appearence of the structure; if you generate structures
 * automatically, you probably won't need that, and if the user generates
 * them, you'll need to use the "real" interfaces anyway
 */

// helper
class SBuilderModule {
protected:
	Arts::ModuleDesc_var _module;
	string _name;

public:
	SBuilderModule(Arts::ModuleDesc_ptr module, const char *name);
	~SBuilderModule();

	const char *name();

	// returns a duplicated port, so you should put it into a _var
	Arts::PortDesc_ptr findPort(const char *portname);
};

// main class
class StructureBuilder {
protected:
	Arts::Synthesizer_var Synthesizer;
	Arts::ModuleBroker_var ModuleBroker;
	Arts::StructureDesc_var StructureDesc;
	bool haveStructureDesc;
	list<SBuilderModule *> modules;

	bool _okay;
	string _error;

	Arts::PortDesc_ptr findPort(const char *port);
public:
	StructureBuilder(Arts::Synthesizer_ptr Synthesizer);
	~StructureBuilder();

	// returns true if all operations performed until now were successful
	bool okay();

	// returns the first error message when okay is false
	const char *error();

	void createModule(const char *moduletype, const char *name);
	void setStringValue(const char *portname, const char *value);
	void setFloatValue(const char *portname, float value);
	void connect(const char *srcportname, const char *destportname);

	// creates one instance of the structure
	long execute(const Arts::ArtsServerSeq& preferredServers);

	// returns the duplicate'd structure description
	Arts::StructureDesc_ptr structureDesc();
};

#endif
