#ifndef _QTTRACK_H_
#define _QTTRACK_H_

#include "qtMain.h"
#include "ifTrack.h"

enum { ID_DRUM, ID_TIME, ID_SCORE, ID_WAVE, ID_COMMENT };

class QtTrack;

class TogBut;

class KbTrack;

class MyLabel : public QLabel
{
  Q_OBJECT

 private:
  QPopupMenu * rbmenu;
  QtTrack * qttrack;
  QLineEdit * le;
 public:
  MyLabel( QWidget * parent = 0, const char * name = 0 );

 public slots:

  void mousePressEvent ( QMouseEvent * );
  void changeName();
  void delTrack();
  void setName();
};

class MyChooser : public QLabel
{
  Q_OBJECT

 private:
  QPopupMenu * menu;
  QtTrack * qttrack;
  QPixmap * pmDrum;
  QPixmap * pmTime;
  QPixmap * pmScor;
  QPixmap * pmWave;
  QPixmap * pmComm;

 public:
  MyChooser( QWidget * parent = 0, const char * name = 0 );

 public slots:
  void mousePressEvent ( QMouseEvent * );
  void chooseDrum();
  void chooseMaster();
  void chooseScore();
  void chooseWave();
  void chooseComment();
};


/**
 * This is the qt implementation of a track
 * @author Jan Wuerthner
 * @versoin 0.97
 */
class QtTrack : public QWidget, public IfTrack
{
  Q_OBJECT

 protected:
  KbTrack * track;
  MyLabel * trname;
  MyChooser * type;
  TogBut * mute;
  TogBut * lock;
  
 public:

  /// Constructor
  QtTrack(KbTrack*);

  /// Destructor
  ~QtTrack();
  virtual void erase();

  /// updates the presentation on the screen
  virtual void update();

  /// returns the QtMain Window
  QtMain * gQtMain();

  /// returns the track
  KbTrack * gTrack();

  /// returns the height of a track (calculates it from main)
  int height();

  /// returns the width of a track
  int width();

  /// (only internal use:) corrects the height
  virtual void adjustHeight();

  bool convertType(int);
};

/**
 * This class defines a toggel button, as it is used three times in each track
 * @author Jan Wuerthner
 * @version 0.95
 */
class TogBut : public QLabel
{
  Q_OBJECT
public:
  TogBut( int n, KbTrack * kbtrack, QPixmap * pic, QPixmap * pic2, QWidget * parent=0, const char * name=0);
  virtual void update();
public slots:
  void mousePressEvent ( QMouseEvent * );
private:
  int num;
  KbTrack * track;
  QtTrack * qttrack;
  QPixmap * icon;
  QPixmap * icon2;
};


#endif
