#ifndef _QTSCOREBUTTONS_C_
#define _QTSCOREBUTTONS_C_

#include <qaccel.h>

#include "qtScoreButtons.h"
#include "qtScore.h"

Buttonbar::Buttonbar( QWidget *parent=0, const char *name=0 )
  : KToolBar( parent ), score((QtScore*)parent)
  // QFrame( parent ), score((QtScore*)parent)
{
  KIconLoader *loader = kapp->getIconLoader();

  pb[0] = new QPushButton( this ); pb[0]->setPixmap( loader->loadIcon( "nb1.xpm" ) );
  pb[1] = new QPushButton( this ); pb[1]->setPixmap( loader->loadIcon( "nb2.xpm" ) );
  pb[2] = new QPushButton( this ); pb[2]->setPixmap( loader->loadIcon( "nb4.xpm" ) );
  pb[3] = new QPushButton( this ); pb[3]->setPixmap( loader->loadIcon( "nb8.xpm" ) );
  pb[4] = new QPushButton( this ); pb[4]->setPixmap( loader->loadIcon( "nb16.xpm" ) );
  pb[5] = new QPushButton( this ); pb[5]->setPixmap( loader->loadIcon( "nb32.xpm" ) );
  pb[6] = new QPushButton( this ); pb[6]->setPixmap( loader->loadIcon( "nb64.xpm" ) );
  pb[7] = new QPushButton( this ); pb[7]->setPixmap( loader->loadIcon( "nbD.xpm" ) );
  pb[8] = new QPushButton( this ); pb[8]->setPixmap( loader->loadIcon( "nbT.xpm" ) );

  pb[9] = new QPushButton( this ); pb[9]->setPixmap( loader->loadIcon( "smFlat2.xpm" ) );
  pb[10] = new QPushButton( this ); pb[10]->setPixmap( loader->loadIcon( "smFlat.xpm" ) );
  pb[11] = new QPushButton( this ); pb[11]->setPixmap( loader->loadIcon( "smNo.xpm" ) );
  pb[12] = new QPushButton( this ); pb[12]->setPixmap( loader->loadIcon( "smSharp.xpm" ) );
  pb[13] = new QPushButton( this ); pb[13]->setPixmap( loader->loadIcon( "smSharp2.xpm" ) );

  // position
  QLabel * lPos = new QLabel("pos",this);
  lPos->setGeometry(14,2,30,18);

  sprintf(position," - ");
  qlPosition = new QLabel(position,this);
  qlPosition->setFont(QFont("courier"));
  qlPosition->setGeometry(44,2,82,18);

  // freq
  QLabel * lFreq = new QLabel("freq",this);
  lFreq->setGeometry(132,2,40,18);

  sprintf(freq," - ");
  qlfreq = new QLabel(freq,this);
  qlfreq->setGeometry(162,2,20,18);

  // Note Lengths
  for (int i=0;i<9;i++) {
    pb[i]->setGeometry(192+i*18, 2, 18, 18); pb[i]->setToggleButton(TRUE);
  }
  curlen = 3; pb[3]->setOn(TRUE);
  for (int i=0;i<7;i++) {
    connect(pb[i], SIGNAL(toggled(bool)),SLOT(noteToggle(bool))); pb[i]->setAccel(0x8000 + 49+i); // ALT = 0x8000
  }

  connect(pb[7], SIGNAL(toggled(bool)),SLOT(dotToggle(bool))); pb[7]->setAccel(0x8000 + '.');
  connect(pb[8], SIGNAL(toggled(bool)),SLOT(triToggle(bool))); pb[8]->setAccel(0x8000 + Key_T);

  // Enharmonic Shifts
  QLabel * lEnh = new QLabel("Enh.Shift",this);
  lEnh->setGeometry(192+10*18,2,54,18);
  for (int i=9;i<14;i++) {
    pb[i]->setGeometry(278+i*18, 2, 18, 18); pb[i]->setToggleButton(TRUE);
    connect(pb[i], SIGNAL(toggled(bool)),SLOT(signToggle(bool)));
  }
  curenh = 0; pb[11]->setOn(TRUE);


  setCursor(QCursor(0));

}

void Buttonbar::setPos(int a, int b, int c) {
  if (a+b+c>0) {
    sprintf(position,"%3d.%2d.%3d",a,b,c);
  } else {
    sprintf(position," - ");
  }  
  qlPosition->setText(position);
}

void Buttonbar::setFreq(char c, int o, bool shft, bool ctrl) {
  char s = ' ';
  if (shft && (!ctrl)) s = '#';
  if (ctrl && (!shft)) s = 'b';
  if (s==' ') sprintf(freq,"%c%d",c,o);
  else sprintf(freq,"%c%c%d",c,s,o);
  qlfreq->setText(freq);
}

void Buttonbar::noteToggle(bool on) {
  if (on==TRUE) {
    if (curlen != -1) pb[curlen]->setOn(FALSE);
    for (int i=0;i<7;i++) {
      if (pb[i]->isOn()==TRUE) curlen = i;
    }
    if (curlen==-1) curlen = 3;
    score->sLenValue(curlen+1);
    score->updateCursor();
  } else {
    int x = -1;
    for (int i=0;i<7;i++) {
      if (pb[i]->isOn()==TRUE) x = i;
    }
    if (x==-1) { x=curlen; curlen=-1; pb[x]->setOn(TRUE); }
  }
}

void Buttonbar::dotToggle(bool on) {
  if (on==TRUE) {
    score->sDotValue(TRUE);
  } else {
    score->sDotValue(FALSE);
  }
}

void Buttonbar::triToggle(bool on) {
  if (on==TRUE) {
    score->sTriValue(TRUE);
  } else {
    score->sTriValue(FALSE);
  }
}

void Buttonbar::signToggle(bool on) {
  if (on==TRUE) {
    if (curenh != -99) pb[curenh+11]->setOn(FALSE);
    for (int i=9;i<14;i++) {
      if (pb[i]->isOn()==TRUE) curenh = i-11;
    }
    if (curenh==-99) curenh = 0;
    score->sEnhValue(curenh);
  } else {
    int x = -99;
    for (int i=9;i<14;i++) {
      if (pb[i]->isOn()==TRUE) x = i;
    }
    if (x==-99) { x=curenh; curenh=-99; pb[x+11]->setOn(TRUE); }
  }
}


#endif
