#ifndef _STRETCH_C_
#define _STRETCH_C_

#include "stretch.h"
#include "../kbPart.h"
#include "../kbNote.h"


/**
 *  This is a sample extension. It multiplies all notes positions and lengths by two
 */

Stretch::Stretch()
  : KbPartExtension("Stretch")
{}

/**
 * This defines the algorithm that shall act on a part.
 */
void Stretch::act(KbPart * part) {
  if (part!=0 && part->gFirstAtom()!=0) {
    KbPosition offset = part->gFirstAtom()->gPos();
    for (KbAtom * note=part->gFirstAtom();note!=0;note=note->gNext()) {
      note->sPos(offset+(note->gPos()-offset)*2);
      if (note->isNote()) ((KbNote*)note)->sLen(((KbNote*)note)->gLen()*2);
    }
  }
}


#endif
