#ifndef _KBWAVEEVENT_C_
#define _KBWAVEEVENT_C_

#include "kbWaveEvent.h"

KbWaveEvent::KbWaveEvent( ) : pos(0), filename(0) {}

KbWaveEvent::KbWaveEvent( KbPosition p, char * name ) : pos(p), filename(name) {}


KbPosition KbWaveEvent::gPos() { return pos; }

void KbWaveEvent::sPos(KbPosition p) { pos = p; }

char * KbWaveEvent::gFileName() { return filename; }

void KbWaveEvent::sFileName(char * name) {
  if (filename) delete[] filename;
  filename = (char*) strdup(name);
}

bool KbWaveEvent::isNote() { return false; }

bool KbWaveEvent::isAuxElement() { return false; }

bool KbWaveEvent::isMidiEvent() { return true; }

bool KbWaveEvent::isMasterEvent() { return false; }

ostream & KbWaveEvent::print(ostream & s) { // DOIT!
  s << "<WAVE pos=\"" << pos << "\" filename=\"" << filename << "\" />" << endl;
  return s;
}

KbAtom * KbWaveEvent::copy() {
  // cout << "PANIC: KbWaveEvent::copy() not implemented yet!"  << endl;
  return new KbWaveEvent(pos,(char*)strdup(filename));
}

#endif
