#ifndef _KBSTEM_C_
#define _KBSTEM_C_

#include "kbStem.h"
#include "kbNote.h"


KbStem::KbStem(KbNote * n, int d) : KbNoteExt(n), dir(d) {}

void KbStem::flip() {
  if (dir==StemUp) dir = StemDown;
  else dir = StemUp;
}

int KbStem::gDir() { return dir; }

bool KbStem::Up() { return (dir==StemUp); }

bool KbStem::Down() { return (dir==StemDown); }

void KbStem::sDir(int d) { dir = d; }

void KbStem::sUp() { dir = StemUp; }

void KbStem::sDown() { dir = StemDown; }

/*KbNoteExt * KbStem::gNext() {
  KbNoteExt * e = next;
  for (;(e != 0) && (e->isStem()==false); e = e->next) {}
  return e;
  }*/

bool KbStem::isLyrics() { return false; }

bool KbStem::isStem() { return true; }

bool KbStem::isExp() { return false; }

bool KbStem::isBow() { return false; }


ostream & KbStem::print(ostream&s) {
  s << "<STEM dir=\"" << dir << "\" />" << endl;
}

KbNoteExt * KbStem::copy() {
  return new KbStem(note,dir);
}

#endif
