#ifndef _KBMASTEREVENT_C_
#define _KBMASTEREVENT_C_

#include "kbMasterEvent.h"

KbMasterEvent::KbMasterEvent( ) {}

KbMasterEvent::KbMasterEvent(KbPosition p, int t) : pos(p), tempo(t), meter0(0), meter1(0) {}

KbMasterEvent::KbMasterEvent(KbPosition p, int a, int b) : pos(p), tempo(0), meter0(a), meter1(b) {}

KbMasterEvent::KbMasterEvent(KbPosition p, int a, int b, int t) : pos(p), tempo(t), meter0(a), meter1(b) {}

KbPosition KbMasterEvent::gPos() { return pos; }

int KbMasterEvent::gTempo() { return tempo; }

int KbMasterEvent::gMeter0() { return meter0; }

int KbMasterEvent::gMeter1() { return meter1; }

void KbMasterEvent::sTempo(int t) { tempo = t; }

void KbMasterEvent::sPos(KbPosition p) { pos = p; }

bool KbMasterEvent::isNote() { return false; }

bool KbMasterEvent::isAuxElement() { return false; }

bool KbMasterEvent::isMidiEvent() { return false; }

bool KbMasterEvent::isMasterEvent() { return true; }

ostream & KbMasterEvent::print(ostream & s) {
  s << "<MASTER pos=\"" << pos << "\"";
  if (tempo==0) { // meter
    s << " meter0=\"" << meter0 << "\" meter1=\"" << meter1 << "\"";
  } else {
    s << " tempo=\"" << tempo << "\"";
    }
  s << " />" << endl;
  return s;
}

KbAtom * KbMasterEvent::copy() {
  return new KbMasterEvent(pos,meter0,meter1,tempo);
}

#endif
