// KreateCD - CD recording software for the K desktop environment
//
// 1998-2000 by Alexander Feigl <Alexander.Feigl@gmx.de>
//
// This file is subject to the terms and conditions of the GNU General      
// Public License.  See the file COPYING in the main directory of the       
// KreateCD distribution for more details.                                     

#ifndef TOCREADER_INCLUDED
#define TOCREADER_INCLUDED

#include "CDTrack.h"
#include "ProcessInterface.h"

typedef enum CDTrack::TrackType TrackType;

class TOCReader : public ProcessInterface
 {
  Q_OBJECT;
  public:

    int  readTOC(void);

    long int    getTOCDuration(int track);
    long int    getTOCLBA(int track);
    long int    getTOCSum(void);
    TrackType   getTOCType(int track);

  protected:
 
    virtual int invokeTOCReader(void);

    void clearTOC(void);
    void closeTOC(void);

    long int toc_lba[128];
    long int toc_durat[128];
    TrackType toc_ttype[128];
    long int tocsum;
    int toctracks;
 };

#endif


