// KreateCD - CD recording software for the K desktop environment
//
// 1999-2000 by Alexander Feigl <Alexander.Feigl@gmx.de>
//
// This file is subject to the terms and conditions of the GNU General      
// Public License.  See the file COPYING in the main directory of the       
// KreateCD distribution for more details.                                     

#include "LineDialog.h"

#if QT_VERSION >= 200
#include <klineedit.h>
#else
#include <klined.h>
#endif

#include <qlayout.h>
#include <qwindowdefs.h>
#include <qstring.h>


LineDialog::LineDialog( QWidget *parent, const char *name,const char *startstring)
           :QDialog(parent,name,TRUE,WStyle_Customize|WStyle_NoBorder|WStyle_Tool)
 {
  QVBoxLayout *qlay;

  qlay=new QVBoxLayout(this);

#if QT_VERSION >= 200
  EditWidget=new KLineEdit(this,0);
#else
  EditWidget=new KLined(this,0);
#endif
  EditWidget->setText(startstring);
   {
    QSize qsiz;
    qsiz=EditWidget->sizeHint();
    EditWidget->setFixedHeight(qsiz.height());

   }
  qlay->addWidget(EditWidget);
  connect(EditWidget,SIGNAL(returnPressed()),
          this,SLOT(leaveDialog()));
  EditWidget->setFocus();

  qlay->activate();
 }

LineDialog::~LineDialog(void)
 {
 }


void LineDialog::leaveDialog(void)
 {
  done(0);
 }

const char *LineDialog::getInput(void)
 {
  return(EditWidget->text());
 }
