// KreateCD - CD recording software for the K desktop environment
//
// 1998-2000 by Alexander Feigl <Alexander.Feigl@gmx.de>
//
// This file is subject to the terms and conditions of the GNU General      
// Public License.  See the file COPYING in the main directory of the       
// KreateCD distribution for more details.                                     

#ifndef CDWriter_INCLUDED
#define CDWriter_INCLUDED

#include <qwidget.h>
#include <kprocess.h>

#include "ProcessInterface.h"

class CDTrack;

class CDWriter : public ProcessInterface
 {
  Q_OBJECT;
  public:
    enum  Fixating {Fix_None,Fix_Session,Fix_CD};

         int    burnCD(int ntrack,CDTrack **track,int simmode,int speed,Fixating fix,int eject);
    long int    getCDFree(int ntrack=0,CDTrack **track=0,Fixating fix=Fix_CD);

  protected:
         int    callRecord(int ntrack,CDTrack **track,int simmode,int speed,Fixating fix,int eject,bool capread=false);
     virtual int       processExited(void);
     virtual bool    processStdoutLine(char *buffer);
     virtual bool    processStderrLine(char *buffer);

  private:
    int burnstate,burntrack,burnsize,burnoffset;

    bool     getCapacity;
    long int blocksTotal;
    long int blocksFree;
    long int blocksRemain;
 };

#endif


