// KreateCD - CD recording software for the K desktop environment
//
// 2000 by Alexander Feigl <Alexander.Feigl@gmx.de>
//
// This file is subject to the terms and conditions of the GNU General      
// Public License.  See the file COPYING in the main directory of the       
// KreateCD distribution for more details.                                     

#ifndef AUDIOFILECONVERT_INCLUDED
#define AUDIOFILECONVERT_INCLUDED

#include "AudioFileOp.h"
#include "AudioFile.h"
#include <qobject.h>

#include <unistd.h>

class AudioFileConvert : public AudioFileOp
 {
   Q_OBJECT
   public:
    AudioFileConvert(AudioFile *afil);
    AudioFileConvert(AudioFile *afil,int (*fx)(AudioFileOp *afi,const char *fn),const char *fnx);


   protected:

    long int                     startAudio;
    int      buildImageFork(const char *fn,int playmode);
    static int buildImageHFork(AudioFileOp *afi,const char *fn);


 };
#endif

