// KreateCD - CD recording software for the K desktop environment
//
// 2000 by Alexander Feigl <Alexander.Feigl@gmx.de>
//
// This file is subject to the terms and conditions of the GNU General
// Public License.  See the file COPYING in the main directory of the
// KreateCD distribution for more details.

#include "AudioFileConvert.h"
#include "AudioFile.h"

#include <stdlib.h>
#include <stdio.h>
#include <strings.h>
#include <unistd.h>
#include <fcntl.h>

#include <sys/stat.h>
#include <sys/ioctl.h>

#include <qtimer.h>
#include <qobject.h>
#include <klocale.h>

#if defined(__FreeBSD__)
# include <machine/soundcard.h>
#else
# include <linux/soundcard.h>
#endif

AudioFileConvert::AudioFileConvert(AudioFile *afil):AudioFileOp(afil)
 {

 }


AudioFileConvert::AudioFileConvert(AudioFile *afil,int (*fx)(AudioFileOp *afi,const char *fn),const char *fnx):AudioFileOp(afil,fx,fnx)
 {

 }


int AudioFileConvert::buildImageFork(const char *fn,int playmode)
 {
  int channel;
  long int samplesleft,maxsamples;
  float pos2;
  long int sample1[2],sample2[2];
  long int sampleswritten=0;
  float boost[2];
  long int start,end;


  if (myAudio->Balance>0)
   {
    boost[0]=myAudio->BoostFactor*(1-myAudio->Balance);
   }
   else
   {
    boost[0]=myAudio->BoostFactor;
   }

  if (myAudio->Balance<0)
   {
    boost[1]=myAudio->BoostFactor*(1+myAudio->Balance);
   }
   else
   {
    boost[1]=myAudio->BoostFactor;
   }


  if (!openWrite(fn))
   {
    return(0);
   }

  start=myAudio->SelectedStart;
  end=myAudio->SelectedEnd;

  if (playmode)
   {
    int sound_size=16,sound_stereo=1,sound_rate=44100;
    if (fcntl(STDIN_FILENO,F_SETFL,O_NONBLOCK)==-1)
     {
      closeWrite();
      return(0);
     }
    if (ioctl(ImageFD, SNDCTL_DSP_SAMPLESIZE, &sound_size)==-1)
     {
      closeWrite();
      return(0);
     }
    if (ioctl(ImageFD, SNDCTL_DSP_STEREO, &sound_stereo)==-1)
     {
      closeWrite();
      return(0);
     }

    if (ioctl(ImageFD, SNDCTL_DSP_SPEED, &sound_rate)==-1)
     {
      closeWrite();
      return(0);
     }
    DisableSwap=1;
    if (startAudio!=-1)
     {
      start=startAudio*588;
      if (start>=end)
       {
        end=myAudio->DataSamples-1;
       }
     }
        fprintf(stdout,"#PROGRESS# %ld\n",(start)/588);
    fflush(stdout);

  }


  if (!openRead(myAudio->FileName))
   {
    closeWrite();
    remove(fn);
    return(0);
   }
  if (!positionSample(start))
   {
    closeRead();
    closeWrite();
    remove(fn);
    return(0);
   }
  samplesleft= (end+1)-start;
  maxsamples=samplesleft;

  if (!readSample(&sample1[0]))
   {
    closeRead();
    closeWrite();
    remove(fn);
    return(0);
   }
  if (myAudio->SampleChannels>1)
   {

    if (!readSample(&sample1[1]))
     {
      closeRead();
      closeWrite();
      remove(fn);
      return(0);
     }
   }
   else
   {
    sample1[1]=sample1[0];
   }


  for (channel=2;channel<myAudio->SampleChannels;++channel)
   {
    long int dummy;
    if (!readSample(&dummy))
     {
      closeRead();
      closeWrite();
      remove(fn);
      return(0);
     }
   }
  samplesleft--;
  pos2=0;
  sample2[0]=sample1[0];
  sample2[1]=sample1[1];

  for (channel=0;channel<2;++channel)
   {
    if (!writeCDDASample(sample1[channel]))
     {
      closeRead();
      closeWrite();
      remove(fn);
      return(0);
     }
   }
  ++sampleswritten;

  while ( (samplesleft>0) || (pos2>=1) )
   {
    int xchannel;

    if (pos2>=1)
     {
      for (channel=0;channel<2;++channel)
       {
        if (myAudio->SampleRate!=44100)
         {
          sample1[channel]= (long int) (sample1[channel]+
            ( (float) (sample2[channel]-sample1[channel]) *
            ((float) 1)/ pos2 ));
         }
         else
         {
          sample1[channel]=sample2[channel];
         }

        if (!writeCDDASample((float)sample1[channel]*boost[channel]))
         {
          closeRead();
          closeWrite();
          remove(fn);
          return(0);
         }
       }
      sampleswritten++;
      pos2-=1;
      continue;
     }
    if (!readSample(&sample2[0]))
     {
      closeRead();
      closeWrite();
      remove(fn);
      return(0);
     }
    if (myAudio->SampleChannels>1)
     {

      if (!readSample(&sample2[1]))
       {
        closeRead();
        closeWrite();
        remove(fn);
        return(0);
       }
     }
     else
     {
      sample2[1]=sample2[0];
     }


    for (xchannel=2;xchannel<myAudio->SampleChannels;++xchannel)
     {
      long int dummy;
      if (!readSample(&dummy))
       {
        closeRead();
        closeWrite();
        remove(fn);
        return(0);
       }
     }
    samplesleft--;
    if ((samplesleft%1000)==0)
     {
      if (!playmode)
       {
        fprintf(stdout,"#PROGRESS# %ld %ld\n",(maxsamples-samplesleft)/1000,(maxsamples+999)/1000);
       }
       else
       {
        char inbuf[80];
        while ( fgets(inbuf,80,stdin)!=0)
         {
          if (strncmp(inbuf,"#BOOST#",7)==0)
           {
            sscanf(inbuf+8,"%f",&myAudio->BoostFactor);
            if (myAudio->Balance>0)
             {
              boost[0]=myAudio->BoostFactor*(1-myAudio->Balance);
             }
             else
             {
              boost[0]=myAudio->BoostFactor;
             }

            if (myAudio->Balance<0)
             {
              boost[1]=myAudio->BoostFactor*(1+myAudio->Balance);
             }
             else
             {
              boost[1]=myAudio->BoostFactor;
             }
           }


          if (strncmp(inbuf,"#BALANCE#",9)==0)
           {
            sscanf(inbuf+10,"%f",&myAudio->Balance);
            if (myAudio->Balance>0)
             {
              boost[0]=myAudio->BoostFactor*(1-myAudio->Balance);
             }
             else
             {
              boost[0]=myAudio->BoostFactor;
             }

            if (myAudio->Balance<0)
             {
              boost[1]=myAudio->BoostFactor*(1+myAudio->Balance);
             }
             else
             {
              boost[1]=myAudio->BoostFactor;
             }
           }



          if (strncmp(inbuf,"#SET#",5)==0)
           {
            unsigned long newpos,xend;
            xend=myAudio->SelectedEnd;
            newpos=strtoul(inbuf+5,0,10);
            newpos*=588;
            if ((signed long) newpos>=myAudio->SelectedEnd) xend=myAudio->DataSamples-1;
            samplesleft= (xend+1)-newpos;
            maxsamples=samplesleft;
            if (!positionSample(newpos))
             {
              closeRead();
              closeWrite();
              remove(fn);
              return(0);
              }
            ioctl(ImageFD,SNDCTL_DSP_SYNC,0);
            fprintf(stdout,"#PROGRESS# %ld\n",newpos/588);
            fflush(stdout);
           }
         }
       }
     }
    pos2+= (float) 44100/ (float) myAudio->SampleRate;
   }

  samplesleft=0;
  if (sampleswritten%588!=0)
   {
    samplesleft=588-(sampleswritten%588);
   }

  if ( (!playmode) && (sampleswritten<(44100*4)))
   {
    samplesleft=(44100*4)-sampleswritten;
   }
  samplesleft*=2;
  while (samplesleft)
   {
    --samplesleft;
    if (!writeCDDASample(0))
     {
      closeRead();
      closeWrite();
      remove(fn);
      return(0);
     }
   }

  if (!flushCDDABuffer())
   {
    closeRead();
    closeWrite();
    remove(fn);
    return(0);
   }
  if (playmode)
   {
    ioctl(ImageFD,SNDCTL_DSP_SYNC,0);
   }
  closeRead();
  closeWrite();
  return(1);
 }

