// KreateCD - CD recording software for the K desktop environment
//
// 1999 by Alexander Feigl <Alexander.Feigl@gmx.de>
//
// This file is subject to the terms and conditions of the GNU General      
// Public License.  See the file COPYING in the main directory of the       
// KreateCD distribution for more details.                                     

#include <qwidget.h>
#include <qdialog.h>
#include <qlistview.h>

class ProgressDialog : public QDialog
 {
  Q_OBJECT;

  signals:
    void canceled(void);

  public:
    ProgressDialog( QWidget *parent=0, const char *name=0, const char *workingtext=0,bool modal=true);
    ~ProgressDialog(void);
    void addStatusView(void);
    void printStatusLine(QString line);

  public slots:
    void setWorkText(const char *newworktext=0);
    void abortDialog(int returncode=-1);
    void abortCancel(void);
    void setProgress(long int val,long int maxval);
    void setProtectedProgress(long int val,long int maxval); // don't decrease values

  protected slots:
    void cancelPressed(void);

  private:
     class KProgress *pwidget;
     class QPushButton *pcancel; 
     class QVBoxLayout *pvlayout;
     class QLabel *pwork;
     class KEdit *edit;

     long int oldval,oldmax;
     char progresstext[2048];
     char worktext[1024];

 };


