// KreateCD - CD recording software for the K desktop environment
//
// 1999 by Alexander Feigl <Alexander.Feigl@gmx.de>
//
// This file is subject to the terms and conditions of the GNU General      
// Public License.  See the file COPYING in the main directory of the       
// KreateCD distribution for more details.                                     

#include <qwidget.h>
#include <qlabel.h>
#include <qcheckbox.h>
#include <qradiobutton.h>

#include <klined.h>

class ISOOptions : public QWidget
 {
  Q_OBJECT;
  
 
  public:
    ISOOptions( QWidget *parent=0, const char *name=0,class ISOImage *track=0);
    ~ISOOptions(void);
    void hide(void);
 
  signals:
    void closed(void);
    void needUpdate(void);

  public slots:
    void updateWindow(void);

  protected slots:
    void doUnix(void);
    void doUnixWin(void);
    void doWin(void);
    void doMSDos(void);

  private:
    class ISOImage *iso;

    QCheckBox *tdotButton;
    QCheckBox *noDeepButton;
    QCheckBox *longNameButton;
    QCheckBox *leadDotButton;
    QCheckBox *omitVerButton;
    QCheckBox *rockButton;
    QCheckBox *anoRockButton;
    QCheckBox *transTabButton;
    QCheckBox *jolietButton;
    QCheckBox *allButton;

    QRadioButton *unixButton;
    QRadioButton *unixWinButton;
    QRadioButton *winButton;
    QRadioButton *msDOSButton;


    QLabel *appIDLabel;
    KLined *appIDEdit;
    QLabel *sysIDLabel;
    KLined *sysIDEdit;
    QLabel *volIDLabel;
    KLined *volIDEdit;
    QLabel *preIDLabel;
    KLined *preIDEdit;
    QLabel *pubIDLabel;
    KLined *pubIDEdit;

 };


