/***************************************************************************
                          mastercd.h  -  description
                             -------------------
    begin                : Tue Mar 6 2001
    copyright            : (C) 2001 by Kai Heitkamp
    email                : koncd@kai-heitkamp.de
 ***************************************************************************/


#ifndef MASTERCD_H
#define MASTERCD_H

#include <qwidget.h>
#include <kprocess.h>
#include <mastercd_gui.h>

#include "imgprocout.h"
#include "processoutput.h"

/**
  *@author Kai Heitkamp
  */

class MasterCD : public MasterCD_GUI  {
   Q_OBJECT

public:
	MasterCD(QWidget *parent=0, const char *name=0);
	~MasterCD();

protected:
	ProcessOutput procoutdlg;
	ImgProcOut imgprocoutdlg;

private:
	int MS_Start, MS_End, FS_Size;
	bool existsSession;

protected slots:
	void slot_quit();
	void slot_start();
	void abort_handler();
	void slot_setSourceDir();
	void slot_setImageFile();
	void slot_setBootImage();
	void slot_imageType();
	void slot_toggleBootableCD();
	void slot_toggleWriteCD();
	void slot_toggleCreateImage();
	void slot_toggle_onthefly();
	void slot_multisession();
	void slot_makeImage();
	void slot_writeCD();
	void slot_writeCD_onthefly();
	void slot_deleteTrack();
	void slot_calculateSize();
	void slot_calculateProcessExited(KProcess *);
	void slot_calculateRecStderr(KProcess *, char *, int);
	void slot_burnRecStderr(KProcess *, char *, int);
	void slot_burnProcessExited(KProcess *);
	void slot_makeImageStdout(KProcess *, char *, int);
	void slot_makeImageProcessExited(KProcess *);
	void slot_MSInfo();
	void slot_MSOutput( KProcess *, char *, int);
	void slot_MSInfoExited(KProcess *);
	void slot_PrintSize();
	void slot_PrintSizeOutput( KProcess *, char *, int);
	void slot_PrintSizeExited(KProcess *);

};

#endif
