/***************************************************************************
                          tools.cpp  -  description
                             -------------------
    begin                : Sun Feb 6 2000
    copyright            : (C) 2000 by Kai Heitkamp
    email                : koncd@kai-heitkamp.de
 ***************************************************************************/

#include <kmsgbox.h>

#include "koncd.h"
#include "tools.h"

Tools::Tools(QWidget *parent, const char *name) : QDialog(parent,name,true){
	setCaption( i18n( "KOnCD - CD Tools" ) );
	initDialog();
	setupConnections();
}

Tools::~Tools(){
}

// Setup Connections
void Tools::setupConnections(){
	connect( QPushButton_Start, SIGNAL(clicked()), SLOT(slotStart()) );
	connect( QPushButton_Quit, SIGNAL(clicked()), SLOT(slotQuit()) );
}

//---Start cdrecord---
void Tools::slotStart(){
	int rc;
	KConfig *config = kapp->getConfig();

	QPushButton_Start->setEnabled( false );
	QPushButton_Quit->setEnabled( false );

	process.clearArguments();
	process << "cdrecord" << "-v";

	//Set the CD-Writer first
	config->setGroup("CD-Writer");
	process << config->readEntry("Device");

	//Set CD-Writer Options to KProcess
	if( QCheckBox_Eject->isChecked() ) process << "-eject";
	if( QCheckBox_Force->isChecked() ) process << "-force";
	if( QCheckBox_Fix->isChecked() ) process << "-fix";

	//Set CD-RW Options to KProcess
	if( (rc = QComboBox_CDRWBlanking -> currentItem()) )
		{
	   	if( rc == 1 ) process << "blank=all";
	   	if( rc == 2 ) process << "blank=fast";
	   	if( rc == 3 ) process << "blank=track";
	   	if( rc == 4 ) process << "blank=unreserve";
	   	if( rc == 5 ) process << "blank=trtrail";
	   	if( rc == 6 ) process << "blank=unclose";
	   	if( rc == 7 ) process << "blank=session";
	   	}

	//Set CD-Writer Speed to KProcess
	if( (rc = QComboBox_WriterSpeed -> currentItem()) )
		{
	   	if( rc == 0 ) process << "speed=1";
	   	if( rc == 1 ) process << "speed=2";
	   	if( rc == 2 ) process << "speed=4";
	   	if( rc == 3 ) process << "speed=6";
	   	if( rc == 4 ) process << "speed=8";
	   	}

	StatusLabel -> setText( i18n("Prepare for write...") );

	//Connect the OK- / Start-Button Signals from ProcessOutput Class to Slots in this (MasterCD) Class
	connect( QPushButton_Abort, SIGNAL(clicked()), SLOT(slotAbort()) );

	//Connect with slotRecStderr to update KProgress (Write- / Buffer-Status) and StatusLine
	connect( &process, SIGNAL(receivedStdout (KProcess *, char *, int) ), this, SLOT(slotRecStderr (KProcess *, char *, int) ));
	connect( &process, SIGNAL(receivedStderr (KProcess *, char *, int) ), this, SLOT(slotRecStderr (KProcess *, char *, int) ));

	//Connect the 'processExited' Signal to the 'slotProcessFinished' Slot
	connect( &process, SIGNAL(processExited(KProcess *)), this, SLOT(slotProcessExited(KProcess *)));

	//Start KProcess
	if( ! process.start( KProcess::NotifyOnExit, KProcess::AllOutput ) )
		{
		KMsgBox::message( this, i18n("KOnCD - Error"), i18n("Couldn't start cdrecord !"), 2 );
		return;
		}

}

//
void Tools::slotRecStderr( KProcess *proc, char *buffer, int buflen ){
	char buf[1024];

	if( !buflen ) {
		return;
	}
	bzero( buf, sizeof( buf ) );
	strncpy( buf, buffer, buflen > (int) sizeof( buf ) ? sizeof(buf) - 1 : buflen );
	//Add cdrecord Messages to the Output-Window
	Output->insertLine( buf );
	//Go to the End of the Output-Text
	Output->setCursorPosition(Output->numLines(),0,false);

	if( strstr( buf, "Blanking" )) {
		StatusLabel -> setText( i18n("Blanking the CDRW...") );
	}

	if( strstr( buf, "Blanking time" )) {
		StatusLabel -> setText( i18n("Blanking-Process complete.") );
	}

	if( strstr( buf, "Fixating..." )) {
		StatusLabel -> setText( i18n("Writing TOC...") );
	}

	if( strstr( buf, "Fixating time:" )) {
		StatusLabel -> setText( i18n("Burn-Process complete.") );
   	}

}

//
void Tools::slotProcessExited( KProcess *rcproc ){
   int noperms = 13;		//Exitcode for no enough permissions
   int nodriver = 19;		//Exitcode for no driver
	int nocdr = 255;		//Exitcode for no CD-R in the Writer-Device
	int corruptcd = 254;	//Exitcode for corrupt CD in Writer-Device

	//KProcess did exit normally, it does have a valid exit status
	if( rcproc->exitStatus() != 0 )
		{
		QString statusout;
		statusout.sprintf( "\nError, exit status: %d\n", rcproc->exitStatus() );
		Output->insertLine( statusout );
		Output->setCursorPosition(Output->numLines(),0,false);
		StatusLabel -> setText( i18n( "An Error is occurred !" ) );
		if( rcproc->exitStatus() == nocdr ) StatusLabel -> setText( i18n( "Error: No CD-R(W) in the Writer-Device !" ) );
		if( rcproc->exitStatus() == corruptcd ) StatusLabel -> setText( i18n( "Error: Corrupt CD in the Writer-Device !" ) );
		if( rcproc->exitStatus() == noperms ) StatusLabel -> setText( i18n( "Error: You don't have enough permissions !" ) );
		if( rcproc->exitStatus() == nodriver ) StatusLabel -> setText( i18n( "Error: Can't open SCSI-Driver !" ) );
		}

	//If KProcess already running, kill it
	if( process.isRunning() ) process.kill();

	QPushButton_Start->setEnabled( true );
	QPushButton_Quit->setEnabled( true );

}

//
void Tools::slotAbort(){
	//Kill KProcess and enable the OK-Buton
	if( process.isRunning() ) process.kill();
	QPushButton_Start->setEnabled( true );
}

//'Quit-Button' clicked
void Tools::slotQuit(){
	close( true );
}
