/***************************************************************************
                          imagetype.cpp  -  description
                             -------------------
    begin                : Thu Jan 27 2000
    copyright            : (C) 2000 by Kai Heitkamp
    email                : koncd@kai-heitkamp.de
 ***************************************************************************/

#include <kconfig.h>

#include "koncd.h"
#include "imagetype.h"

ImageType::ImageType(QWidget *parent, const char *name) : QDialog(parent,name,true){
	setCaption( i18n( "KOnCD - Set Image-Type" ) );
	initDialog();
	setupConnections();
	readImageType();
}

ImageType::~ImageType(){
}

// Setup Connections
void ImageType::setupConnections(){
	connect( QPushButton_OKandsave, SIGNAL(clicked()), SLOT(slotQuitandSave()) );
	connect( QPushButton_Quit, SIGNAL(clicked()), SLOT(slotExit()) );
	connect( QComboBox_ImageType, SIGNAL(activated(int)), SLOT(slotImageTypeChange(int)) );
}

//Read the Imagetype and settings from config file
void ImageType::readImageType(){
	KConfig *config = kapp->getConfig();

	config->setGroup( "Image-Type" );

	//Read name from configfile and set ComboBox
	if ( config->readEntry( "Name" ) == "Unix Rock-Ridge" ) QComboBox_ImageType->setCurrentItem( 0 );
	if ( config->readEntry( "Name" ) == "Rock-Ridge + Win9x/NT" ) QComboBox_ImageType->setCurrentItem( 1 );
	if ( config->readEntry( "Name" ) == "Win9x/NT (long filenames)" ) QComboBox_ImageType->setCurrentItem( 2 );
	if ( config->readEntry( "Name" ) == "MS-DOS" ) QComboBox_ImageType->setCurrentItem( 3 );
	if ( config->readEntry( "Name" ) == "Custom" ) QComboBox_ImageType->setCurrentItem( 4 );

	//Read settings from configfile and set the CheckBoxes
	QCheckBox_Allowlongfilenames->setChecked( config->readBoolEntry( "Allowlongfilenames" ) );
	QCheckBox_Rockridgeextensions->setChecked( config->readBoolEntry( "Rockridgeextensions" ) );
	QCheckBox_Rockridgewithanonymity->setChecked( config->readBoolEntry( "Rockridgewithanonymity" ) );
	QCheckBox_Jolietextensions->setChecked( config->readBoolEntry( "Jolietextensions" ) );
	QCheckBox_Omittrailingperiods->setChecked( config->readBoolEntry( "Omittrailingperiods" ) );
	QCheckBox_Dontusedeepdirrelocations->setChecked( config->readBoolEntry( "Dontusedeepdirrelocations" ) );
	QCheckBox_Allowfilesbeginningwithadot->setChecked( config->readBoolEntry( "Allowfilesbeginningwithadot" ) );
	QCheckBox_Omitisoversionnumbers->setChecked( config->readBoolEntry( "Omitisoversionnumbers" ) );
}

//QComboBox_ImageType change
void ImageType::slotImageTypeChange( int index ){
	switch ( index )
	{
		//Unix Rock-Ridge
		case 0:	QCheckBox_Allowlongfilenames->setChecked( true );
						QCheckBox_Rockridgeextensions->setChecked( false );
						QCheckBox_Rockridgewithanonymity->setChecked( true );
						QCheckBox_Jolietextensions->setChecked( false );
						QCheckBox_Omittrailingperiods->setChecked( false );
						QCheckBox_Dontusedeepdirrelocations->setChecked( false );
						QCheckBox_Allowfilesbeginningwithadot->setChecked( true );
						QCheckBox_Omitisoversionnumbers->setChecked( false );
						break;

		//Rock-Ridge + Win9x/NT
		case 1:	QCheckBox_Allowlongfilenames->setChecked( true );
						QCheckBox_Rockridgeextensions->setChecked( true );
						QCheckBox_Rockridgewithanonymity->setChecked( true );
						QCheckBox_Jolietextensions->setChecked( false );
						QCheckBox_Omittrailingperiods->setChecked( false );
						QCheckBox_Dontusedeepdirrelocations->setChecked( true );
						QCheckBox_Allowfilesbeginningwithadot->setChecked( true );
						QCheckBox_Omitisoversionnumbers->setChecked( false );
						break;

		//Win9x/NT (long filenames)
		case 2:	QCheckBox_Allowlongfilenames->setChecked( true );
						QCheckBox_Rockridgeextensions->setChecked( true );
						QCheckBox_Rockridgewithanonymity->setChecked( false );
						QCheckBox_Jolietextensions->setChecked( false );
						QCheckBox_Omittrailingperiods->setChecked( false );
						QCheckBox_Dontusedeepdirrelocations->setChecked( true );
						QCheckBox_Allowfilesbeginningwithadot->setChecked( true );
						QCheckBox_Omitisoversionnumbers->setChecked( false );
						break;

		//MS-DOS
		case 3:	QCheckBox_Allowlongfilenames->setChecked( false );
						QCheckBox_Rockridgeextensions->setChecked( false );
						QCheckBox_Rockridgewithanonymity->setChecked( false );
						QCheckBox_Jolietextensions->setChecked( false );
						QCheckBox_Omittrailingperiods->setChecked( false );
						QCheckBox_Dontusedeepdirrelocations->setChecked( false );
						QCheckBox_Allowfilesbeginningwithadot->setChecked( false );
						QCheckBox_Omitisoversionnumbers->setChecked( false );
						break;
	}

}

//'OK and Save Button' clicked
void ImageType::slotQuitandSave(){
	KConfig *config = kapp->getConfig();

	//Save Image-Type config
	config->setGroup( "Image-Type" );
	config->writeEntry( "Name", QComboBox_ImageType->currentText() );
	config->writeEntry( "Allowlongfilenames", QCheckBox_Allowlongfilenames->isChecked() );
	config->writeEntry( "Rockridgeextensions", QCheckBox_Rockridgeextensions->isChecked() );
	config->writeEntry( "Rockridgewithanonymity", QCheckBox_Rockridgewithanonymity->isChecked() );
	config->writeEntry( "Jolietextensions", QCheckBox_Jolietextensions->isChecked() );
	config->writeEntry( "Omittrailingperiods", QCheckBox_Omittrailingperiods->isChecked() );
	config->writeEntry( "Dontusedeepdirrelocations", QCheckBox_Dontusedeepdirrelocations->isChecked() );
	config->writeEntry( "Allowfilesbeginningwithadot", QCheckBox_Allowfilesbeginningwithadot->isChecked() );
	config->writeEntry( "Omitisoversionnumbers", QCheckBox_Omitisoversionnumbers->isChecked() );

	close( true );
}

//'Quit-Button' clicked
void ImageType::slotExit(){
	close( true );
}
