int Edit::checkPrerequisites()
{
  string pfad;
  int retCode = 0;

  pfad = whereisExec("mkisofs");
  if (pfad.length() < 2) 
    {
      fehlermeldung(i18n("mkisofs does not seem to be installed on your system.\n"
		    "Please install it as it is one of the basic programs\n"
		    "necessary for cd-creation."));
      retCode = 1;
    }

  pfad = whereisExec("cdrecord");
  if (pfad.length() < 2)
    {
      fehlermeldung(i18n("cdrecord does not seem to be installed on your system.\n"
		    "Please install it as it is one of the basic programs\n"
		    "necessary for cd-creation."));
      retCode = 1;
    }

  return(retCode);
}

void Edit::getGlobalConfDat(KSimpleConfig* &globalConf)
{
  uid_t  meinUID;
  gid_t  meinGID;
  string tmp;
  
  meinGID = getgid();
  meinUID = getuid();
  cerr << "my real UID: " << meinUID << "\n";
  cerr << "my effective UID: " << geteuid() << "\n";
  cerr.flush();
  
  // Den Pfad zur Konfig-Datei bestimmen 
  string confDatPfad;
  
  confDatPfad = KApplication::kde_configdir();
  confDatPfad += "/kisocdrc";
  
  if (!existDat(confDatPfad))
    if (existDat("/etc/defaults/kisocdrc")) confDatPfad = "/etc/defaults/kisocdrc";
    else confDatPfad = "/usr/local/etc/defaults/kisocdrc";
  
  cout << "config file is:" << confDatPfad << " (if it exists)\n";	
  
  globalConf = new KSimpleConfig(confDatPfad.c_str(), true);
  
  globalConf->setGroup("kisocd");

  if (existDat(confDatPfad)
      && globalConf->readEntry("version") != "0.5.0"
      && globalConf->readEntry("version") != "0.5.4"
      && globalConf->readEntry("version") != "0.5.2")	
    {
      // es eine Version vor 0.5.0
      tmp = confDatPfad;
      tmp += i18n("\nYour configuration file does not contain the current version number,\n"
		  "so it obviously won't work as you expect it. Some of the options have\n"
		  "changed with the release of version 0.5, please take a look at the\n"
		  "new ones in the current file.");
      infomeldung(tmp.c_str());
    }
  
  if (existDat(confDatPfad)
      && globalConf->readEntry("version") == "0.5.0")
    {
      // es ist Version 0.5.0
      tmp = confDatPfad;       
      tmp += i18n("\nYour configuration file contains the version number 0.5.0.\n"
		  "Now the current is 0.5.4, change it to suppress this message.\n"
		  "What exactly has changed:\n"
		  "There's a new option \"oBasics_padTrack = [true | false]\"\n"
		  "corresponding to the new switch \"options|cd|basics|pad data track\"\n"
		  "more things...");
      infomeldung(tmp.c_str());
    }

  if (existDat(confDatPfad)
      && globalConf->readEntry("version") == "0.5.2")
    {
      // es ist Version 0.5.2
      tmp = confDatPfad;       
      tmp += i18n("\nYour configuration file contains the version number 0.5.2.\n"
		  "Now the current is 0.5.4, change it to suppress this message.\n"
		  "What exactly has changed:\n"
		  "It is possible to give a list of available speeds for burning/blanking\n"
		  "and to set a speed for blanking.");
      infomeldung(tmp.c_str());
    }
  
  tmp = "u" + itoStr(meinUID, ' ', 1);
  cout << "Searching for UID: [" << tmp << "]..";
  globalConf->setGroup(tmp.c_str());
  tmp = "g" + itoStr(meinGID, ' ', 1);    
  if (globalConf->readEntry("settings", "none") == "none")
    {
      cout << "...not there, take GID: [" << tmp << "]\n";
      globalConf->setGroup(tmp.c_str());
    }
  tmp = globalConf->readEntry("settings", "none");
  if (tmp != "none" && tmp != "custom")
    {
      cout << "...link to [" << tmp << "]\n";
      globalConf->setGroup(tmp.c_str());	
      tmp = globalConf->readEntry("settings", "none");
    }
  cout << "Settings: " << tmp << "\n";
}

void Edit::makeNewLatexFile(string  HeimatPfad, 
			    QString htmldir)
{  
  // kopiert die Musterdatei fr das LatexFile von irgendwoher (muss noch festgelegt werden,
  // bisher ist das Verzeichnis vorgesehen, in dem auch die Hilfedateien stehen werden)
  // nach "HeimatPfad"/cdDoc.tex. Wird faulerweise einfach ber einen Systemaufruf gemacht.
  
  string befehl = "cp ";
  string tmpPfad;

  befehl += htmldir;
  befehl +="/en/kisocd/cdDocMuster.tex " 
    + HeimatPfad 
    + "/cdDoc.tex &> ";
  tmpPfad = getNrFile("/tmp/", "kisocd");
  befehl += tmpPfad;
  
  if (system(befehl.c_str()))
    {
      befehl = HeimatPfad + "/tmp.out";
      befehl = i18n("Error copying latex-file:\n") + dateiInhalt(befehl);
      fehlermeldung(befehl.c_str());
    }
  unlink(tmpPfad.c_str());
}

void Edit::saveOptions(struct T_Options      &defOpts, 
		       struct T_FileOptions  &fileOpts,
		       string                HeimatPfad)
{
  KSimpleConfig  *configDat;
  string         defPfad;
  
  defPfad = HeimatPfad;
  defPfad += "/.config";
  
  configDat = new KSimpleConfig(defPfad.c_str());
  configDat->setGroup("kisocd");
  configDat->writeEntry("version", ProggieVersion);
  
  configDat->setGroup("cdDoc");
  configDat->writeEntry("latexCmd", fileOpts.latexCmd.c_str());
  configDat->writeEntry("viewCmd", fileOpts.viewCmd.c_str());
  configDat->writeEntry("printCmd", fileOpts.printCmd.c_str());
  configDat->writeEntry("editorCmd", fileOpts.editorCmd.c_str());      
  configDat->writeEntry("fAutoCompile", fileOpts.fAutoCompile);
  
  configDat->setGroup("system");
  configDat->writeEntry("mountPoint", fileOpts.mountPoint.c_str());      
  configDat->writeEntry("imageFilePath", fileOpts.imageFilePath.c_str());
  configDat->writeEntry("writeDevice", fileOpts.writeDevice.c_str());
  configDat->writeEntry("writeDeviceSFile", fileOpts.writeDeviceSFile.c_str());
  configDat->writeEntry("nFifoSize", fileOpts.nFifoSize);
  configDat->writeEntry("nWritingSpeedImg", fileOpts.nWritingSpeedImg);
  configDat->writeEntry("nWritingSpeedOTF", fileOpts.nWritingSpeedOTF);     
  configDat->writeEntry("nBlankingSpeed", fileOpts.nBlankingSpeed);     
  configDat->writeEntry("availSpeed", fileOpts.availSpeed.c_str());     
  
  configDat->writeEntry("fShutdown", fileOpts.fShutdown);
  configDat->writeEntry("fEject", fileOpts.fEject);    
  
  configDat->setGroup("cdDefault");
  configDat->writeEntry("IDdisc", defOpts.IDdisc.c_str());
  configDat->writeEntry("IDvolume", defOpts.IDvolume.c_str());
  configDat->writeEntry("IDpreparer", defOpts.IDpreparer.c_str());
  configDat->writeEntry("IDpublisher", defOpts.IDpublisher.c_str());
  configDat->writeEntry("bootImagePath", defOpts.bootImagePath.c_str());    
  configDat->writeEntry("fFollowSymLinks", defOpts.switches[0]);
  configDat->writeEntry("fAllowLeadingDots", defOpts.switches[1]);
  configDat->writeEntry("fAllFiles", defOpts.switches[2]);
  configDat->writeEntry("fNames32Char", defOpts.switches[3]);
  configDat->writeEntry("fJoliet", defOpts.switches[4]);
  configDat->writeEntry("fTRANSTBL", defOpts.switches[5]);
  configDat->writeEntry("fMkisofsVerbose", defOpts.switches[6]);
  configDat->writeEntry("fRRchmod", defOpts.switches[7]);
  configDat->writeEntry("fRR", defOpts.switches[8]);
  configDat->writeEntry("fMulti", defOpts.fMulti);
  configDat->writeEntry("fbootCD", defOpts.fbootCD);
  configDat->writeEntry("fCreateImage", defOpts.fCreateImage);
  configDat->writeEntry("fDummyWrite", defOpts.fDummyWrite);
  configDat->writeEntry("fPadTrack", defOpts.fPadTrack);
  configDat->writeEntry("fMultiFirstSess", defOpts.fMultiFirstSess);
  configDat->writeEntry("fMultiLastSess", defOpts.fMultiLastSess);
  configDat->sync();
  delete configDat;
}

void Edit::setDefaultConfig(struct T_Options      &aktOpts, 
			    struct T_FileOptions  &fileOpts,
			    string                HeimatPfad)
{
  for (int Cnt = 0; Cnt<9; Cnt++) 
    aktOpts.switches[Cnt] = false;
  
  aktOpts.switches[2] = true;
  
  aktOpts.IDdisc      = "Disc-ID";
  aktOpts.IDvolume    = "Volume-ID";
  aktOpts.IDpreparer  = "Preparer-ID";
  aktOpts.IDpublisher = "Publisher-ID";
  aktOpts.fCreateImage   = true;
  aktOpts.fDummyWrite    = false;
  aktOpts.fPadTrack      = true;
  aktOpts.fbootCD        = false;
  aktOpts.bootImagePath  = "/home/none.set";
  aktOpts.fMulti         = false;
  aktOpts.fMultiFirstSess= true;
  aktOpts.fMultiLastSess = false;
  
  fileOpts.latexCmd  = "latex";
  fileOpts.viewCmd   = "xdvi";
  fileOpts.printCmd  = "dvips";
  fileOpts.editorCmd = "kedit";
  fileOpts.fAutoCompile = true;
  fileOpts.writeDevice  = "0,4,0 (Plextor CD-ROM)";
  fileOpts.writeDeviceSFile   = "/dev/scd0";
  fileOpts.mountPoint   = "/mnt";
  fileOpts.imageFilePath  = "/tmp/stupid_place.raw";
  fileOpts.nFifoSize      = 4;
  fileOpts.nWritingSpeedImg  = 2;
  fileOpts.nWritingSpeedOTF  = 2;
  fileOpts.nBlankingSpeed    = 2;
  fileOpts.availSpeed = "1,2,4,6,8,12,16,";
  
  fileOpts.fEject    = true;
  fileOpts.fShutdown = false;
}

int Edit::ladeVorgaben(KSimpleConfig*        globalConf,
		       string                HeimatPfad,
		       struct T_Options      &aktOpts, 
		       struct T_FileOptions  &fileOpts)
  // liefert true zurck, wenn es die Datei nicht gab oder
  // wenn sie zu einer alten Version gehrte.
{
  KSimpleConfig    *configDat;
  string           defPfad;
  int              ersterStart = 0;
  
  defPfad = HeimatPfad;
  defPfad += "/.config";
  
  configDat = new KSimpleConfig(defPfad.c_str(), true);
  configDat->setGroup("kisocd");
  
  // nur zur Sicherheit:
  setDefaultConfig(aktOpts, fileOpts, HeimatPfad);

  if (!existDat(defPfad) || configDat->readEntry("version", "none") == "none")
    {
      ersterStart = 1;
    }
  else
    {  
      configDat->setGroup("cdDoc");
      fileOpts.latexCmd  = configDat->readEntry("latexCmd");
      fileOpts.viewCmd   = configDat->readEntry("viewCmd");
      fileOpts.printCmd  = configDat->readEntry("printCmd");
      fileOpts.editorCmd = configDat->readEntry("editorCmd");      
      fileOpts.fAutoCompile = configDat->readBoolEntry("fAutoCompile");
      
      configDat->setGroup("system");
      fileOpts.mountPoint    = configDat->readEntry("mountPoint");      
      fileOpts.imageFilePath = configDat->readEntry("imageFilePath");
      fileOpts.writeDevice   = configDat->readEntry("writeDevice");
      fileOpts.writeDeviceSFile    = configDat->readEntry("writeDeviceSFile");
      fileOpts.nFifoSize        = configDat->readNumEntry("nFifoSize");
      fileOpts.nWritingSpeedImg = configDat->readNumEntry("nWritingSpeedImg");
      fileOpts.nWritingSpeedOTF = configDat->readNumEntry("nWritingSpeedOTF");
      fileOpts.nBlankingSpeed   = configDat->readNumEntry("nBlankingSpeed");     
      if (globalConf->readEntry("availSpeed", "noValue") != "noValue")
	fileOpts.availSpeed       = configDat->readEntry("availSpeed");     
      
      fileOpts.fEject = configDat->readBoolEntry("fEject");
      fileOpts.fShutdown = configDat->readBoolEntry("fShutdown");      
      
      configDat->setGroup("cdDefault");
      aktOpts.IDdisc        = configDat->readEntry("IDdisc");
      aktOpts.IDvolume      = configDat->readEntry("IDvolume");
      aktOpts.IDpreparer    = configDat->readEntry("IDpreparer");
      aktOpts.IDpublisher   = configDat->readEntry("IDpublisher");
      aktOpts.bootImagePath = configDat->readEntry("bootImagePath");    
      aktOpts.switches[0] = configDat->readBoolEntry("fFollowSymLinks");
      aktOpts.switches[1] = configDat->readBoolEntry("fAllowLeadingDots");
      aktOpts.switches[2] = configDat->readBoolEntry("fAllFiles");
      aktOpts.switches[3] = configDat->readBoolEntry("fNames32Char");
      aktOpts.switches[4] = configDat->readBoolEntry("fJoliet");
      aktOpts.switches[5] = configDat->readBoolEntry("fTRANSTBL");
      aktOpts.switches[6] = configDat->readBoolEntry("fMkisofsVerbose");
      aktOpts.switches[7] = configDat->readBoolEntry("fRRchmod");
      aktOpts.switches[8] = configDat->readBoolEntry("fRR");
      aktOpts.fMulti = configDat->readBoolEntry("fMulti");
      aktOpts.fbootCD = configDat->readBoolEntry("fbootCD");
      aktOpts.fCreateImage = configDat->readBoolEntry("fCreateImage");
      aktOpts.fDummyWrite = configDat->readBoolEntry("fDummyWrite");
      aktOpts.fPadTrack = configDat->readBoolEntry("fPadTrack");
      aktOpts.fMultiFirstSess = configDat->readBoolEntry("fMultiFirstSess");
      aktOpts.fMultiLastSess = configDat->readBoolEntry("fMultiLastSess");
    }
  delete configDat;

  // Jetzt die (strkeren) Vorgaben aus der globalen Datei laden

  // cdDoc
  if (globalConf->readEntry("oCDDoc_latex", "noValue") != "noValue")
    fileOpts.latexCmd   = globalConf->readEntry("oCDDoc_latex");
  if (globalConf->readEntry("oCDDoc_view", "noValue") != "noValue")
    fileOpts.viewCmd    = globalConf->readEntry("oCDDoc_view");
  if (globalConf->readEntry("oCDDoc_print", "noValue") != "noValue")
    fileOpts.printCmd   = globalConf->readEntry("oCDDoc_print");
  if (globalConf->readEntry("oCDDoc_editor", "noValue") != "noValue")
    fileOpts.editorCmd  = globalConf->readEntry("oCDDoc_editor");   
  
  // System
  if (globalConf->readEntry("oSys_writeDeviceSFile", "noValue") != "noValue")
    fileOpts.writeDeviceSFile     = globalConf->readEntry("oSys_writeDeviceSFile");
  if (globalConf->readEntry("oSys_writeDevice", "noValue") != "noValue")
    fileOpts.writeDevice     = globalConf->readEntry("oSys_writeDevice");
  if (globalConf->readEntry("oSys_mntpnt", "noValue") != "noValue")
    fileOpts.mountPoint = globalConf->readEntry("oSys_mntpnt");
  if (globalConf->readEntry("oSys_availSpeed", "noValue") != "noValue")
    fileOpts.availSpeed = globalConf->readEntry("oSys_availSpeed");
  if (globalConf->readNumEntry("oSys_speedImg", 65000) != 65000)
    fileOpts.nWritingSpeedImg = globalConf->readNumEntry("oSys_speedImg");
  if (globalConf->readNumEntry("oSys_speedOTF", 65000) != 65000)
    fileOpts.nWritingSpeedOTF = globalConf->readNumEntry("oSys_speedOTF");
  if (globalConf->readNumEntry("oSys_speedBlank", 65000) != 65000)
    fileOpts.nBlankingSpeed = globalConf->readNumEntry("oSys_speedBlank");
  if (globalConf->readEntry("oSys_imagePath", "noValue") != "noValue")
    fileOpts.imageFilePath = globalConf->readEntry("oSys_imagePath");
  if (globalConf->readNumEntry("oSys_fifoSize", 65000) != 65000)
    fileOpts.nFifoSize     = globalConf->readNumEntry("oSys_fifoSize");
  if (globalConf->readEntry("oSys_availSpeed", "noValue") != "noValue")
    fileOpts.availSpeed     = globalConf->readEntry("oSys_availSpeed");
    
  if (globalConf->readEntry("oSys_eject", "noValue") != "noValue")
    fileOpts.fEject     = (globalConf->readEntry("oSys_eject") == "true");    
  if (globalConf->readEntry("oSys_shutdown", "noValue") != "noValue")
    fileOpts.fShutdown  = (globalConf->readEntry("oSys_shutdown") == "true");    

  // cd  
  if (globalConf->readEntry("oFS_followSymLnk", "noValue") != "noValue")
    aktOpts.switches[0] = (globalConf->readEntry("oFS_convLdngDots") == "true");
  if (globalConf->readEntry("oFS_convLdngDots", "noValue") != "noValue")
    aktOpts.switches[1] = !(globalConf->readEntry("oFS_convLdngDots") == "true");
  if (globalConf->readEntry("oFS_32char", "noValue") != "noValue")
    aktOpts.switches[3] = (globalConf->readEntry("oFS_32char") == "true");
  if (globalConf->readEntry("oFS_joliet", "noValue") != "noValue")
    aktOpts.switches[4] = (globalConf->readEntry("oFS_joliet") == "true");
  if (globalConf->readEntry("oFS_trans", "noValue") != "noValue")
    aktOpts.switches[5] = (globalConf->readEntry("oFS_trans") == "true");
  if (globalConf->readEntry("oFS_RRchangeFlags", "noValue") != "noValue")
    aktOpts.switches[7] = (globalConf->readEntry("oFS_RRchangeFlags") == "true");
  if (globalConf->readEntry("oFS_RR", "noValue") != "noValue")
    aktOpts.switches[8] = (globalConf->readEntry("oFS_RR") == "true");
  
  if (globalConf->readEntry("oBasics_createImgFile", "noValue") != "noValue")
    aktOpts.fCreateImage  = (globalConf->readEntry("oBasics_createImgFile") == "true");
  if (globalConf->readEntry("oBasics_dummyWrite", "noValue") != "noValue")
    aktOpts.fDummyWrite  = (globalConf->readEntry("oBasics_dummyWrite") == "true");
  if (globalConf->readEntry("oBasics_padTrack", "noValue") != "noValue")
    aktOpts.fPadTrack  = (globalConf->readEntry("oBasics_padTrack") == "true");
  
  if (globalConf->readEntry("oBasics_createBootCD", "noValue") != "noValue")
    aktOpts.fbootCD = (globalConf->readEntry("oBasics_createBootCD") == "true");
  if (globalConf->readEntry("oBootCD_imgPath", "noValue") != "noValue")  
    aktOpts.bootImagePath = globalConf->readEntry("oBootCD_imgPath");

  if (globalConf->readEntry("oBasics_createMultiCD", "noValue") != "noValue")
    aktOpts.fMulti = (globalConf->readEntry("oBasics_createMultiCD") == "true");
  
  // ein paar Sicherheitschecks
  if (fileOpts.mountPoint[0] != '/') fileOpts.mountPoint = "/mnt";
  
  // berprfen von fileOpts.imageFilePath
  if (fileOpts.imageFilePath[fileOpts.imageFilePath.size()-1] == '/')
    {
      fehlermeldung(i18n("Please give a valid path for the imagefile!\n"
			 "(options|more)\n"
			 "I corrected it to a default which possibly makes\n"
			 "no sense but will not cause strange errors. The point\n"
			 "is that you have to give a file, not a directory!"));  
      fileOpts.imageFilePath = "/usr/local/stupid_place.raw";
    }

  //  fileOpts.availSpeed evtl. korrigieren
  {
    if (fileOpts.availSpeed[fileOpts.availSpeed.length()-1] != ',') fileOpts.availSpeed += ',';

    for (int cnt=0; cnt < fileOpts.availSpeed.length(); cnt++)
      {
	if (fileOpts.availSpeed.length() == 0) break;
	if (!isdigit(fileOpts.availSpeed[cnt]) && fileOpts.availSpeed[cnt] != ',')
	  fileOpts.availSpeed.replace(cnt--, 1, "");
      }
    while (fileOpts.availSpeed.length() != 0 && !isdigit(fileOpts.availSpeed[0]))
      fileOpts.availSpeed.replace(0, 1, "");
  }

  return(ersterStart);
}

int Edit::preBurningBox()
  // Liefert 
  //     0 bei "nicht brennen"/Abbruch, 
  //     1 bei "brennen", 
  //     2 bei "brennen aber nicht shutdown"
{
  int tmp;

  if (fileOpts.fShutdown)
    {
      tmp = QMessageBox::warning(this, i18n("Really sure?"), 
				 i18n("Start the writing process now and shutdown the whole system\n"
				      "when it has finished?\n"
				      "In case of shutdown you may lose data that has not been\n"
				      "saved yet!!"),
				 i18n("Yes, burn it!"), 
				 i18n("Burn it, but don't shutdown"), 
				 i18n("No, abort"), 
				 2, 2);
      switch (tmp) {
      case 0: return(1);
      case 1: return(2);
      default: return(0);
      }
    }
  else 
    {
      tmp = QMessageBox::warning(this, i18n("sure?"), 
				 i18n("Start the writing process now?"),
				 i18n("Yes, burn it!"), i18n("No, abort"), 
				 0, 1, 1);
      if (tmp == 0) return(1);
      else return(0);
    }
}






