#ifndef _DIRCOMBO_H_
#define _DIRCOMBO_H_

#include <qframe.h>
#include <qlistbox.h>
#include <qcombobox.h>
#include "kexplorer.def"

class ListBoxItem : public QListBoxItem
{
public:
	ListBoxItem(const char *name, QPixmap *pm, int depth = 0);
	virtual int height(const QListBox *lb) const;
	virtual int width(const QListBox *lb) const;

	int depth() { return Depth;}
	QPixmap* icon() { return Icon;}

protected:
	virtual void paint(QPainter *p);

private:
	QPixmap		*Icon;
	int		Depth;
};

class DirList : public QListBox
{
public:
	DirList(QWidget *parent = 0, const char *name = 0, WFlags f = 0) : QListBox(parent,name,f) {}
	QListBoxItem* item(int index) const { return QListBox::item(index);}
	QListBoxItem* currentItem() const { return (QListBox::currentItem() >= 0 ? QListBox::item(QListBox::currentItem()) : 0);}
	int current() { return QListBox::currentItem();}
};

class DirCombo : public QComboBox
{
public:
	DirCombo(QWidget *parent = 0, const char *name = 0);

	void insertItem(const char *name, QPixmap *pm, int depth = 0);
	void setCurrentItem(int index);

protected:
	virtual void paintEvent(QPaintEvent *e);

private:
	DirList		*ListBox;
};

#endif
