#include "OpenDlg.h"
#include <qpushbutton.h>
#include <qlabel.h>
#include <kapp.h>

OpenDlg::OpenDlg(KMimeAppList *list, KPIconLoader *Loader, QWidget *parent = 0, const char *name = 0)
	: QDialog(parent,name,TRUE)
{
	setCaption(i18n("Open with ..."));
	resize(250,350);

	QLabel	*label = new QLabel(i18n("Select an application :"),this);
	label->setGeometry(10,10,230,20);

	EditText = new QLineEdit(this);
	EditText->setGeometry(10,40,230,25);

	ListView = new QListView(this);
	ListView->setGeometry(10,75,230,230);
	ListView->setFrameStyle(QFrame::Panel | QFrame::Sunken);
	ListView->setLineWidth(2);
	ListView->addColumn(i18n("Name"));
	ListView->setColumnWidth(0,100);
	ListView->addColumn(i18n("Description"));
	ListView->setColumnWidth(1,150);
	connect(ListView,SIGNAL(selectionChanged(QListViewItem*)),SLOT(activated(QListViewItem*)));
	connect(ListView,SIGNAL(doubleClicked(QListViewItem*)),SLOT(dblClicked(QListViewItem*)));

	QListViewItem	*item;
	KMimeAppListIterator	it(*list);
	for (;it.current();++it) {
		item = new QListViewItem(ListView,it.current()->AppName.data(),it.current()->Description.data(),it.current()->ExecString.data());
		item->setPixmap(0,*(Loader->loadKDEIcon(it.current()->MimeIcon.data())));
	}

	QPushButton	*ok = new QPushButton(i18n("Ok"),this);
	ok->setGeometry(20,315,70,25);
	connect(ok,SIGNAL(clicked()),SLOT(accept()));
	QPushButton	*cancel = new QPushButton(i18n("Cancel"),this);
	cancel->setGeometry(170,315,70,25);
	connect(cancel,SIGNAL(clicked()),SLOT(reject()));
}

OpenDlg::~OpenDlg()
{
}

void OpenDlg::activated(QListViewItem *item)
{ EditText->setText(item->text(2));}

void OpenDlg::dblClicked(QListViewItem *)
{ accept();}