/*
 * Implements KTrackListBox
 *
 * $Id: ktracklst.cpp,v 1.2 1998/08/05 16:36:04 core Exp $
 *
 */

#include "ktracklst.h"
#include "ktracklst.moc"

#include <kdebug.h>
#include <klocale.h>

KTrackListBox::KTrackListBox( QWidget *parent=0, const char *name=0, int columns=1, WFlags f=0 )
  : KTabListBox( parent, name, columns, f )
{
  // set some defaults...
  _allowDrag = _showTitle = FALSE;
  _dragSource = 0;
  listCount = 0;
}

KTrackListBox::~KTrackListBox()
{
  for ( int i = 0; i < listCount; i++ ) {
    delete list[i]->track;
    delete list[i];
  }
}

void KTrackListBox::dragEndEvent()
{
  emit dragEnded( 0 );
}

void KTrackListBox::allowDrag( bool allow = true )
{
  _allowDrag = allow;
}

void KTrackListBox::showTitle( bool show = true )
{
  _showTitle = show;
}

void KTrackListBox::setDragSource( int dragSource )
{
  _dragSource = dragSource;
}

int KTrackListBox::insertTrack( CdTrackInfo *track, QString title = "", QString filename = "", int index = -1 )
{
  QString tmp;
  int i;
  TrackListItem *item;

  if ( title = "" ) {
    title.sprintf( "Track %d", track->track() );
  };

  if ( index == -1 ) { index = listCount; };
  if ( index > listCount ) { index = listCount; };

  for ( i = listCount; i > index; i-- ) {
    list[i] = list[i-1];
  };

  item = new TrackListItem;
  item->track = track;
  item->title = title;
  item->filename = filename;
  list[index] = item;

  tmp = printLine( index );
  insertItem( tmp, index );
  setColor( index );
  
  listCount++;
 return listCount;
}

void KTrackListBox::removeTrack( int index )
{
  int i;

  if ( (index < listCount) && ( index >= 0 ) ) {
    for ( i = index+1; i <= listCount; i++ ) {
      list[i-1] = list[i];
    };
    listCount--;
    removeItem( index );
  } else {
    KDEBUG1( KDEBUG_ERROR, 0, "KtrackListBox::removeTrack( %d ): index out of range !", index );
  };
}

CdTrackInfo *KTrackListBox::track( int index )
{
  if ( (index < listCount) && ( index >= 0 ) ) {
    return list[index]->track;
  } else {
    KDEBUG1( KDEBUG_ERROR, 0, "KTrackListBox::track( int index ): index out of range ! [%d]", index );
    return NULL;
  };
}

int KTrackListBox::count()
{
  return listCount;
}

int KTrackListBox::pos( CdTrackInfo *track )
{
  int i, tmp;
  long id;

  id = track->trackId();
  tmp = -1;
  for ( i=0; i < listCount; i++ ) {
    if ( list[i]->track->trackId() == id ) { tmp = i; };
  };
  return tmp;
}

void KTrackListBox::setColor( int index )
{
  if ( ( list[index]->filename == " " ) || ( list[index]->filename == "-= working =-" ) ) 
    {
      changeItemColor( QColor( 0xDD, 0x00, 0x00 ), index );
    } else {
      changeItemColor( QColor( 0x00, 0x00, 0x00 ), index );
    };
}

void KTrackListBox::setFilename( int index, QString filename )
{
  list[index]->filename = filename;
  changeItem( printLine( index ), index );
  setColor( index );
  repaint();
}

QString KTrackListBox::filename( int index )
{
  return list[index]->filename;
}

void KTrackListBox::setTitle( int index, QString title )
{
  list[index]->title = title;
  changeItem( printLine( index ), index );
}

QString KTrackListBox::title( int index )
{
  return list[index]->title;
}

QString KTrackListBox::printLine( int index )
{
  QString out, tmp, tmp2;

  out = list[index]->title + "\t";
  tmp.sprintf( "%s\t%3dM\t%s ", list[index]->track->trackTimeString().data(), list[index]->track->trackSize()/1024, list[index]->filename.data() );
  out += tmp;
  
  return out;
}

bool KTrackListBox::prepareForDrag( int col, int row, char **data, int *size, int *type )
{
  if ( _allowDrag ) {
    dd.dragSource = _dragSource;
    dd.listBox = this;
    
    *data = (char*)&dd;
    *type = DndRawData;
    *size = sizeof( dd );
    return true;
  } else {
    return false;
  };
}

