#ifndef _kcdraudio_h
#define _kcdraudio_h

/********************************************************************
 *								     
 * The "Read audio CD" tab page
 *	
 * $Id: kraudiocd.h,v 1.3 1998/08/05 16:36:03 core Exp $
 */

#include "ocdrom.h"
#include "playpanel.h"

#include <qgrpbox.h>
#include <qpushbt.h>
#include <qlayout.h>
#include <qfileinf.h>

#include <ktablistbox.h>
#include <kdebug.h>
#include <kconfig.h>
#include <kapp.h>
#include <kprocess.h>
#include "ktracklst.h"

/**
 * stores which tracks had been droped onto the buffer but not yet read. 
 */
struct RQueueItem
{
  RQueueItem *next;
  CdTrackInfo *track;
};


/**
 *
 *
 */
class KReadAudioCd : public QGroupBox
{
  Q_OBJECT

 public:    
  KReadAudioCd( QWidget *parent=0, KTrackListBox *aBufListBox=0 );
  virtual ~KReadAudioCd();

  bool trackInfo( CdTrackInfo *trackInfo );
  int queueTrack( CdTrackInfo *track );
  int dequeueTrack();
  int setReading( bool start );
  int reading();
  void readNextTrack();
  void updateStatus();
  void startReading( bool start );

  virtual bool quitOk();
  virtual void timerEvent( QTimerEvent *e );
  
 signals:
  void queueChanged();
  void updateStatus( QString text, int progress );

  void addTrackToBuff( CdTrackInfo *track, QString title, QString filename );
  void setFilenameInBuff( CdTrackInfo *track, QString filename );
  void setTitleInBuff( CdTrackInfo *track, QString title );

  void saveBuffer();

 public slots:
  void trackSkip( int track );
  void newCd();
  void childExited( KProcess * );

  void pbtAddTracks();
  void pbtAddAllTracks();
  void pbtStartReadingSlot();

  void dragEnded( int index );
  void buffDeleteTrack( CdTrackInfo *track );

  void cdStatusChange( CdPlayPanel::CdPanelStatus status );
  
 public:
  bool autostartReading;
  KConfig *config;
  KTrackListBox *cdListBox, *bufListBox;
  QPushButton *pbtStartReading;
  CdPlayPanel *playPanel;
  RQueueItem *queueHead;
  RQueueItem *queueTail;
  int queueCount, maxQueued, read;
  long maxQueuedSize, readSize;
  KShellProcess *proc;
  QString execute;
  QFileInfo *tmpFileInfo;

 public:
  Cdrom *cdrom;
};



#endif
