 /***************************************************************************
                          quantaview.h  -  description
                             -------------------
    begin                :   18 23:09:05 EET 1999
    copyright            : (C) 1999 by Yacovlev Alexander & Dmitry Poplavsky
    email                : pdima@mail.univ.kiev.ua
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef QUANTAVIEW_H
#define QUANTAVIEW_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif 

// include files for Qt
#include <qwidget.h>

class QuantaApp;
class QuantaDoc;

class QVBoxLayout;

class KWrite;
class KWriteDoc;
class KToolBar;
class KHTMLView;
class CTabCtl;
class FileTabBar;
class QWidgetStack;

/** The QuantaView class provides the view widget for the QuantaApp instance.	
 * The View instance inherits QWidget as a base class and represents the view object of a KTMainWindow. As QuantaView is part of the
 * docuement-view model, it needs a reference to the document object connected with it by the QuantaApp class to manipulate and display
 * the document structure provided by the QuantaDoc class.
 * 	
 * @author Source Framework Automatically Generated by KDevelop, (c) The KDevelop Team.
 * @version KDevelop version 0.4 code generation
 */
class QuantaView : public QWidget
{
  Q_OBJECT
  public:
    /** Constructor for the main view */
    QuantaView(QWidget *parent = 0, QuantaApp *_app = 0, const char *name=0);
    /** Destructor for the main view */
    ~QuantaView();

    /** returns a pointer to the document connected to the view instance. Mind that this method requires a QuantaApp instance as a parent
     * widget to get to the window document pointer by calling the QuantaApp::getDocument() method.
     *
     * @see QuantaApp#getDocument
     */
    QuantaDoc *getDocument() const;

    /** contains the implementation for printing functionality */
    void print(QPrinter *pPrinter);
    /** repaint preview */
    void repaintPreview( bool scroll = true);
    /** return current KWrite class */
    KWrite * write();
    /** remove KWrite class from stack, return id of new KWrite */
    KWrite* removeWrite();
    /**  */
    KWrite * write(int id);
  /** save scroll position */
  void saveScroll();
  /** set scroll */
  void setScroll();
	
  private:
	
public: // Public attributes

  /** Tab bar for tool bars */
  CTabCtl *tabBar;
  /** Top  layout  with tool bars and view */
  QVBoxLayout *topLayout;
  /** tool bar Standard */
  KToolBar *bStandard;
  /** tool bar fonts */
  KToolBar *bFonts;
  /** tool bar fonts */
  KToolBar *bTables;
  /** tool bar fonts */
  KToolBar *bForms;
  /** tool bar fonts */
  KToolBar *bLists;
  /** tool bar fonts */
  KToolBar *bOther;
  /** HTML View class */
  KHTMLView *html;
  /** This is pointer to Doc class */
  QuantaDoc *doc;
  /** This is pointer to app class */
  QuantaApp *app;
  /** collum of cursor position */
  int column;
  /** x,y scroll position*/
  int scrollX, scrollY;
  /** space have collum space */
  QString space;
  /** kwrite document class */
  KWriteDoc *writeDoc;
  /**  */
  FileTabBar * fileTabBar;
  /** stack of kwrite classes */
  QWidgetStack * writeStack;
private: // Private attributes
  /** height of tool bar */
  int barHeight;
public slots: // Public slots
  /** Callback for toolbar with tags. */
  void slotToolbarCallback( int id );
  /** insert <img > tag */
  void slotTagImg();
  /** for <a href> tag */
  void slotTagA();
  /** fro <a href=mailto> tag  */
  void slotTagMail();
  /** quick html text generate */
  void slotTagQuickStart();
  /** insert  <font> tag in document */
  void slotTagFont();
  /** insert tag <basefont> */
  void slotTagBaseFont();
  /** for tag <table> */
  void slotTagTable();
  /** do quick list */
  void slotTagQuickList();
  /** for quick create table */
  void slotTagQuickTable();
  /** for row properties */
  void slotTagTableRow();
  /** head properties */
  void slotTagTableHead();
  /** table data properties */
  void slotTagTableData();
  /** Open color Dialog and
insert color in the text */
  void slotTagColor();
  /**  */
  void slotTagFormRadio();
  /** insert TextArea tag */
  void slotTagFormTextArea();
  /** insert Form tag */
  void slotTagForm();
  /**  */
  void slotTagFormCheck();
  /**  */
  void slotTagFormPas();
  /**  */
  void slotTagFormLineEdit();
  /** insert  &nbsp; */
  void slotTagNbsp();
  /** insert <br> tag */
  void slotTagBr();
  /** Add new kwrite class to
      writeStack and return id in stack */
  /** insert date */
  void slotTagDate();
  /** for select form */
  void slotTagSelect();
  /** insert text area form */
  void slotTagTextArea();
  int addWrite( KWrite *w, char *label);
  /**  */
  void selectWrite(int id);
signals: // Signals
  /** emit when select document from tabbar */
  void writeSelected(int);
};


#include <ktabctl.h>

/**
  *this class provide the functionality to switchs the tabs, without a mouseclick
  *@author Sandy Meier
  */
class CTabCtl : public KTabCtl {
  Q_OBJECT
public:
  /**constructor
   type = normal,output_widget
  */

  CTabCtl(QWidget* parent=0,char* name=0,QString type="normal");
  /**destructor*/
  ~CTabCtl(){};

public:
  /** set the top tab*/
  void setCurrentTab(int id);
  int getCurrentTab();




};

#endif // QUANTAVIEW_H
