/*************************************************************
*
* (c) 1999, 2000 Christoph Pinkel
* This is part of the VisKProg project.
*
* You may use it under the terms of the GPL licence.
* See COPYING for more details!
*
**************************************************************/

#include "winedit.h"
#include "winedit.moc"

winedit::winedit( QWidget *parent, const char *fName = 0L ) : QWidget(parent)
{
int i;
QString str;

	modified = true;

	tool = ID_NO_TOOL;
	actualI = -1;

	if ( fName != 0L && fName[0] != '/' )
	{
		str = QDir::currentDirPath();
		str = QString( str +"/" +fName );

		fName = (const char *)str;
	}
	else
		str = fName;

	haveHBar = false; haveVBar = false;

	win = new topWin(this);

	win->resize( 300, 200 );

	connect( win, SIGNAL( mr() ), SLOT( mr() ) );
	connect( win, SIGNAL(newWidget(int,int,int,int,widgetHolder *)),
		SLOT(newWidget(int,int,int,int,widgetHolder *)) );

	connect( win, SIGNAL(resetTool()), SLOT(resetTool()) );

	connect( win, SIGNAL(modified()), SLOT(setModified()) );

	connect( win, SIGNAL(showEvent(QString,QString)),
		SLOT(showEvt(QString,QString)) );

	for ( i = 0; i < MAX_SUBS; i++ )
	{
		swins[i] = 0L;
		sbut[i] = 0L;
		slab[i] = 0L;
		splab[i] = 0L;
		sedi[i] = 0L;
		slist[i] = 0L;
		schk[i] = 0L;
		sopt[i] = 0L;
		shscr[i] = 0L;
		spr[i] = 0L;
	}

	dWid = new QWidget( this );
	dWid->hide();

	if ( str != 0L )
	{
		fn = str;

		if ( !open( fn ) )
		{
			dirName = "";
			fn = "";
		}


	}
	else
	{
		dirName = "";
		fn = "";

	}


}


bool winedit::save()
{
int i;

	if (!hasName()) return false;

	if (!saveWid( win, true ))
		return false;

	for ( i = 0; i < MAX_SUBS; i++ )
		if ( swins[i] != 0L )
			if ( !saveWid( swins[i] ) )
				return false;

	return true;
}



bool winedit::close()
{
int i;

	//Delete all widgets and unregister them:
	for( i = 0; i < MAX_SUBS; i++ )
	{

		if( sbut[i] != 0L )
		{
			delete sbut[i];
			sbut[i] = 0L;
		}

		if( slab[i] != 0L )
		{
			delete slab[i];
			slab[i] = 0L;
		}

		if( splab[i] != 0L )
		{
			delete splab[i];
			splab[i] = 0L;
		}

		if( sedi[i] != 0L )
		{
			delete sedi[i];
			sedi[i] = 0L;
		}

		if( slist[i] != 0L )
		{
			delete slist[i];
			slist[i] = 0L;
		}

		if( schk[i] != 0L )
		{
			delete schk[i];
			schk[i] = 0L;
		}

		if( sopt[i] != 0L )
		{
			delete sopt[i];
			sopt[i] = 0L;
		}

		if( shscr[i] != 0L )
		{
			delete shscr[i];
			shscr[i] = 0L;
		}

		if( spr[i] != 0L )
		{
			delete spr[i];
			spr[i] = 0L;
		}

	}

	for( i = 0; i < MAX_SUBS; i++ ) //Sub windows not before others are deleted
		if( swins[i] != 0L )
		{
			delete swins[i];
			swins[i] = 0L;
		}

	fn = "";

	dirName = "";

	if (haveHBar) delete hBar;
	if (haveVBar) delete vBar;
	dWid->hide();
	haveHBar = false;
	haveVBar = false;

	resetTool();

	win->destroyBars();

	delete win;

	return true;

}


bool winedit::closeAndNew()
{

	if ( !close() ) return false;

	modified = true;

	// new window:
	win = new topWin(this);

	win->resize( 300, 200 );
	checkZoom();
	win->show();

	connect( win, SIGNAL( mr() ), SLOT( mr() ) );
	connect( win, SIGNAL(newWidget(int,int,int,int,widgetHolder *)),
		SLOT(newWidget(int,int,int,int,widgetHolder *)) );

	connect( win, SIGNAL(resetTool()), SLOT(resetTool()) );

	connect( win, SIGNAL(modified()), SLOT(setModified()) );

	connect( win, SIGNAL(showEvent(QString,QString)),
			SLOT(showEvt(QString,QString)) );

	return true;

}


void winedit::openWid( const char *name, widgetHolder *parent  )
{
int i, ii,  ch = ' ';
int p = -1;
char aStr[2] = " ";
QString inCode;
QFile f(name);
struct inFile inf;
widgetHolder *whol, *swh = 0L;
char expr1[EXPR_LEN], expr2[EXPR_LEN];
QString *qsp1, *qsp2;

	if ( !f.open( IO_ReadOnly ) )
	{
		KMsgBox::message( 0L, "Can't open", QString ("Invalid project:\nFile \"")
			+(name) +("\" not in actual directory.") );

		fatal( "Missing file \"%s\" declared in another project file.", name );
	}

	for( i = 0; ch != -1; i++ )
	{
		aStr[0] = (char)ch;

		inCode = inCode +aStr;

		ch = f.getch();
	}

	f.close();

	initInF(&inf);

	if ( parent == 0L )
		readParse( &inf, (char *)inCode, 1 );
	else
		readParse( &inf, (char *)inCode, 0 );


	//Build widget:

	tool = ID_WID; //"Drawing" sub windows

	if( parent == 0L )
	{
		win = new topWin(this);

		checkZoom();
		win->show();

		connect( win, SIGNAL( mr() ), SLOT( mr() ) );
		connect( win, SIGNAL(newWidget(int,int,int,int,widgetHolder *)),
			SLOT(newWidget(int,int,int,int,widgetHolder *)) );

		connect( win, SIGNAL(resetTool()), SLOT(resetTool()) );

		connect( win, SIGNAL(modified()), SLOT(setModified()) );

		connect( win, SIGNAL(showEvent(QString,QString)),
			SLOT(showEvt(QString,QString)) );

		whol = win;

	}
	else
	{
		for( p = 0; swins[p] != 0L; p++ )
			if ( p == MAX_SUBS-1 )
				fatal ( "In winedit::openWid(...): Too many sub windows." );

		swins[p] = new subWin( 1, 1, parent );

		swins[p]->show();

		connect( swins[p], SIGNAL(resetTool()), SLOT(resetTool()) );

		connect( swins[p], SIGNAL(newWidget(int,int,int,int,widgetHolder *)),
			SLOT(newWidget(int,int,int,int,widgetHolder *)) );

		connect( swins[p], SIGNAL(modified()), SLOT(setModified()) );

		connect( swins[p], SIGNAL(deleteMe(widgetHolder*)),
			SLOT(deleteWid(widgetHolder*)) );

		connect( swins[p], SIGNAL(testName(QString,widgetHolder*)),
			SLOT(nameExists(QString,widgetHolder*)) );

		connect( swins[p], SIGNAL(showEvent(QString,QString)),
				SLOT(showEvt(QString,QString)) );

		whol = swins[p];

	}

	//Properties:

		//Name:
	getInFName( &inf, expr1 );

	whol->changeProperty( "name", expr1 );


		//Others:
	i = 0;
	for( getInPropN( &inf, 0, expr1 ); expr1[0] != 0L;
		getInPropN( &inf, i, expr1 ) )
	{
		getInPropV( &inf, i, expr2 );

		whol->changeProperty( expr1, expr2 );

		i++;
	}


	//Childs:
	i = 0;
	for( getInSubN( &inf, 0, expr1 ); expr1[0] != 0L;
		getInSubN( &inf, i, expr1 ) )
	{
		getInSubT( &inf, i, expr2 );

		if ( QString(expr2).lower() == "subwindow" ) //start sub call:
		{
			QString saexpr = expr1;

			widgetHolder *tmpWh = whol;

			while( tmpWh != 0L )
			{
				saexpr = nameOf( tmpWh ) +"_" +saexpr;

				tmpWh = tmpWh->getWhParent();
			}

			saexpr = saexpr.lower();

			openWid( QString (dirName) +("/") +(saexpr) +("/") +(saexpr) +(".vkf"), whol );
		}
		else //newWidget and set properties:
		{
			if( QString(expr2).lower() == "button" )
			{
				tool = ID_BUTTON;
				newWidget( 1, 1, 10, 10, whol );
				swh = sbut[actualI];
			}
			else if( QString(expr2).lower() == "label" )
			{
				tool = ID_LABEL;
				newWidget( 1, 1, 10, 10, whol );
				swh = slab[actualI];
			}
			else if( QString(expr2).lower() == "pixlabel" )
			{
				tool = ID_PIXLABEL;
				newWidget( 1, 1, 10, 10, whol );
				swh = splab[actualI];
			}
			else if( QString(expr2).lower() == "lineedit" )
			{
				tool = ID_EDITW;
				newWidget( 1, 1, 10, 10, whol );
				swh = sedi[actualI];
			}
			else if( QString(expr2).lower() == "listbox" )
			{
				tool = ID_LIST;
				newWidget( 1, 1, 10, 10, whol );
				swh = slist[actualI];
			}
			else if( QString(expr2).lower() == "checkbox" )
			{
				tool = ID_CHECKW;
				newWidget( 1, 1, 10, 10, whol );
				swh = schk[actualI];
			}
			else if( QString(expr2).lower() == "optionbutton" )
			{
				tool = ID_OPTIONW;
				newWidget( 1, 1, 10, 10, whol );
				swh = sopt[actualI];
			}
			else if( QString(expr2).lower() == "slider" )
			{
				tool = ID_SLIDER;
				newWidget( 1, 1, 10, 10, whol );
				swh = shscr[actualI];
			}
			else if( QString(expr2).lower() == "procctrl" )
			{
				tool = ID_PROCCTRL;
				newWidget( 1, 1, 10, 10, whol );
				swh = spr[actualI];
			}
			else
			{
				fatal( "In winedit::openWid(...): Unknown sub widget \"%s\".", expr2 );
			}

			getInSubN( &inf, i, expr1 );

			swh->changeProperty( "name", expr1 );

			ii = 0;
			for( getInSubPropN( &inf, i, 0, expr1 ); expr1[0] != 0L;
				getInSubPropN( &inf, i, ii, expr1 ) )
			{
				getInSubPropV( &inf, i, ii, expr2 );

				swh->changeProperty( expr1, expr2 );

				ii++;
			}

		} //else (of :if(sQString(expr2).lower() == "widget" ))

		i++;
	} //for


	//Regionals, Consts, Funcs:

	qsp1 = whol->getVarNames();
	qsp2 = whol->getVarVals();

	i = -1;

	do
	{
		i++;

		getInVarN( &inf, i, (char *)qsp1[i] );
		getInVarV( &inf, i, (char *)qsp2[i] );
	} while( qsp1[i] != "" );

	qsp1 = whol->getConstNames();
	qsp2 = whol->getConstVals();

	i = -1;

	do
	{
		i++;

		getInConstN( &inf, i, (char *)qsp1[i] );
		getInConstV( &inf, i, (char *)qsp2[i] );
	} while( qsp1[i] != "" );

	qsp1 = whol->getFuncNames();
	qsp2 = whol->getFuncVals();

	i = -1;

	do
	{
		i++;

		getInFuncN( &inf, i, (char *)qsp1[i] );
		qsp2[i].setNum( getInFuncA( &inf, i ) );
	} while( qsp1[i] != "" );


	//Update view:
	//(...)

	resetTool();
		
} //openWid(...)


bool winedit::open( const char *newName )
{
QString nme = newName;
QFile f(nme);

	if( !f.open( IO_ReadOnly ) )
	{
		KMsgBox::message( 0L, "Can't open",  QString ("No such file: ") +nme );

		return false;
	}

	if ( !close() ) return false;

	f.close();

	if ( !setDir(QString(dirNme(nme)+"/..")) )
	{
		KMsgBox::message( 0L, "Error", "Can't get directory." );
		abort();
	}


	openWid( nme );

	modified = true;

	return true;

} //open(...)


bool winedit::setDir( const char *newDir )
{
QDir dn;

	if ( !dn.cd(newDir) )
		return false;

	QDir::setCurrent(newDir);

	dirName = dn.absPath();

	return true;
}


bool winedit::hasName()
{
	if ( dirName == "" )
		return false;
	else
		return true;
}


void winedit::setTool( int nTool )
{
int i;
	tool = nTool;

	win->setTool( tool );

	for ( i = 0; i < MAX_SUBS; i++ )
		if ( swins[i] != 0L ) swins[i]->setTool( tool );
}


QString winedit::nameOf( widgetHolder *wid )
{
int i;
QString ps[100], vs[100];

	wid->getProperties( ps, vs );

	for ( i = 0; ps[i] != "Name"; i++ )
	{
		if ( i == 99 || ps[i] == "" )
			fatal ( "In winedit::nameOf(...): Unexpected internal error." );

	}

	return( vs[i] );

}


void winedit::getSubs( QString wt, widgetHolder *rnames[] )
{
int i;

	if ( wt == "SubWindow" )
	{
		rnames[0] = win;

		for( i = 0; i < MAX_SUBS; i++ )
			rnames[i+1] = swins[i];

	}
	else if ( wt == "Button" )
	{

		for( i = 0; i < MAX_SUBS; i++ )
			rnames[i] = sbut[i];

	}
	else if ( wt == "Label" )
	{

		for( i = 0; i < MAX_SUBS; i++ )
			rnames[i] = slab[i];

	}
	else if ( wt == "PixLabel" )
	{

		for( i = 0; i < MAX_SUBS; i++ )
			rnames[i] = splab[i];

	}
	else if ( wt == "LineEdit" )
	{

		for( i = 0; i < MAX_SUBS; i++ )
			rnames[i] = sedi[i];

	}
	else if ( wt == "ListBox" )
	{

		for( i = 0; i < MAX_SUBS; i++ )
			rnames[i] = slist[i];

	}
	else if ( wt == "CheckBox" )
	{

		for( i = 0; i < MAX_SUBS; i++ )
			rnames[i] = schk[i];

	}
	else if ( wt == "OptionButton" )
	{

		for( i = 0; i < MAX_SUBS; i++ )
			rnames[i] = sopt[i];

	}
	else if ( wt == "Slider" )
	{

		for( i = 0; i < MAX_SUBS; i++ )
			rnames[i] = shscr[i];

	}
	else if ( wt == "ProcCtrl" )
	{

		for( i = 0; i < MAX_SUBS; i++ )
			rnames[i] = spr[i];

	}
	else
		fatal( "In winedit::getSubs(...): No such widget type: \"%s\" (Internal error).",
			(const char *) wt );

} //getSubs(...)


QString winedit::dirNme( QString fname )
{
int i;
QString ret;
QString rp(2);
	
	if ( fname == "" ) return "";

	for ( i = fname.length() -1; fname[i] != '/'; i-- )
		if( i == 0 ) return ( "" );

	i--;

	if ( i == -1 )
		return "/";

	while( i >= 0 )
	{
		rp[0] = fname[i]; rp[1] = 0L;

		ret = rp +ret;

		i--;

	} //while

	return ret;

}


QString winedit::pureName( QString fname )
{
int i;
QString ret;
QString rp(2);

	if ( fname == "" ) return "";

	for ( i = fname.length() -1; fname[i] != '/'; i-- )
	{
		if( i == 0 ) return (fname);

		rp[0] = fname[i]; rp[1] = 0L;

		ret = rp +ret;
	}

	return(ret);
}


QString winedit::addPrOf( widgetHolder *wid, QString wType )
{
int i;
QString ps[100], vs[100];
QString wName;
QString ret;

	/* Called by saveWid(...), returns the properties of wid in
	   the VisKProg form file format */

	wid->getProperties( ps, vs );

	for ( i = 0; ps[i] != "Name"; i++ )
	{
		if ( i == 99 || ps[i] == "" )
			fatal ( "In winedit::addPrOff(...): Unexpected internal error #1." );

	}

	wName = vs[i];

	ret = QString ("\t\t") +wType +(" ") +wName
		+( "\n\t\t(\n" );


	for ( i = 0; ps[i] != ""; i++ )
	{
		if ( i == 99  )
			fatal ( "In winedit::addPrOff(...): Unexpected internal error #2." );

		vs[i] = prfilter::encodeQs(vs[i]);
		if ( ps[i] != "Name" )
			ret += "\t\t\t" +ps[i] +" = \"" +vs[i] +"\";\n";
	}


	ret += "\t\t)\n\n";

	return ret;
}


bool winedit::saveWid( widgetHolder *wid, bool isTop )
{
int i;
QString ps[100], vs[100];
QString actualName;
QString outString;

	if (isTop)
		outString = "Window ";
	else
		outString = "SubWindow ";

	wid->getProperties( ps, vs );

	for ( i = 0; ps[i] != "Name"; i++ )
	{
		if ( i == 99 || ps[i] == "" )
			fatal ( "In winedit::saveWid(...): Unexpected internal error #1." );
	}

	actualName = vs[i];

	outString = outString +actualName + "\n(\n\tProperties\n\t(\n";

	for ( i = 0; ps[i] != ""; i++ )
	{
		vs[i] = prfilter::encodeQs(vs[i]);

		if ( i == 99  )
			fatal ( "In winedit::saveWid(...): Unexpected internal error #2." );

		if ( ps[i] != "Name" )
			outString += "\t\t" +ps[i] +" = \"" +vs[i] +"\";\n";
	}

	outString += "\t)\n\n";

	outString += "\tRegional\n\t(\n";

	//Add regional variables:
	for( i = 0; i < 512; i++ )
		if( wid->getVarNames()[i] != "" )
		{
			outString += QString ( ("\t\t") +wid->getVarNames()[i] );
			outString += QString ( (" = \"")
				+prfilter::encodeQs(wid->getVarVals()[i]) +("\";\n") );
		}

	outString += "\t)\n\n";


	outString += "\tRegConst\n\t(\n";

	//Add regional constants:
	for( i = 0; i < 512; i++ )
		if( wid->getConstNames()[i] != "" )
		{

			outString += QString ( ("\t\t") +wid->getConstNames()[i] );
			outString += QString ( (" = \"")
				+prfilter::encodeQs(wid->getConstVals()[i]) +("\";\n") );
		}

	outString += "\t)\n\n";


	outString += "\tFunctions\n\t(\n";

	//Add regional functions:
	for( i = 0; i < 512; i++ )
		if( wid->getFuncNames()[i] != "" )
		{
			outString += QString ( ("\t\t") +wid->getFuncNames()[i] );
			outString += QString ( (": ")
				+wid->getFuncVals()[i] +(";\n") );
		}

	outString += "\t)\n\n";



	//Add sub widget information:
	outString += "\tSubWidgets\n\t(\n";

	for( i = 0; i < MAX_SUBS; i++ )
	{
		if( swins[i] != 0L ) //Widgets
			if ( swins[i]->getParent() == wid )
				outString += addPrOf( swins[i], "SubWindow" );


		if( sbut[i] != 0L ) //Buttons
			if ( sbut[i]->getParent() == wid )
				outString += addPrOf( sbut[i], "Button" );


		if( slab[i] != 0L ) //Labels
			if ( slab[i]->getParent() == wid )
				outString += addPrOf( slab[i], "Label" );

		if( splab[i] != 0L ) //PixLabels
			if ( splab[i]->getParent() == wid )
				outString += addPrOf( splab[i], "PixLabel" );

		if( sedi[i] != 0L ) //Line edits
			if ( sedi[i]->getParent() == wid )
				outString += addPrOf( sedi[i], "LineEdit" );

		if( slist[i] != 0L ) //List boxes
			if ( slist[i]->getParent() == wid )
				outString += addPrOf( slist[i], "ListBox" );

		if( schk[i] != 0L ) //Check boxes
			if ( schk[i]->getParent() == wid )
				outString += addPrOf( schk[i], "CheckBox" );

		if( sopt[i] != 0L ) //Option boxes
			if ( sopt[i]->getParent() == wid )
				outString += addPrOf( sopt[i], "OptionButton" );

		if( shscr[i] != 0L ) //Slider
			if ( shscr[i]->getParent() == wid )
				outString += addPrOf( shscr[i], "Slider" );

		if( spr[i] != 0L ) //Process control
			if ( spr[i]->getParent() == wid )
				outString += addPrOf( spr[i], "ProcCtrl" );


	} //for

	outString += "\t)\n\n)";
	outString += QString (" Generated by  KWinedit, xx-xx-xxxx.\nDon't edit ")
		+("this comment, since changes will be lost when KWinedit saves ")
		+("the file next time.\n");


	if ( !QDir::setCurrent(dirName) )
		return false;

	QDir d;

	if ( isTop )
	{
		actualName = actualName.lower();

		if( !d.cd( actualName ) && !d.mkdir( actualName ) )
			return false;

		actualName += "/" +actualName +".vktf";

	}
	else
	{
		widgetHolder *tmpWid = wid->getWhParent();

		while( tmpWid != 0L )
		{
			actualName = nameOf( tmpWid ) +"_" +actualName;

			tmpWid = tmpWid->getWhParent();
		}

		actualName = actualName.lower();

		if( !d.cd( actualName ) && !d.mkdir( actualName ) )
			return false;

		actualName += "/" +actualName +".vkf";
	}

	actualName = actualName.lower();

	QFile f( actualName );


	if( !f.open( IO_WriteOnly ) )
		return false;

	if ( f.writeBlock( outString, outString.length() ) == -1 )
	{
		f.close();
		return false;
	}

	//OK

	f.flush();
	f.close();

	modified = false;

	return true;

}


void winedit::resizeEvent( QResizeEvent * )
{

	checkZoom();
}


void winedit::setScrollBars( int h, int v )
{

	if ( h > 0 )
	{

		if ( !haveHBar )
		{
			hBar = new QScrollBar( 0, h, 5, 20, 0, QScrollBar::Horizontal,
				this, "HorizontalScroll" );

			connect( hBar, SIGNAL(valueChanged(int)), SLOT(hScrolled(int)) );
		}
		else
		{
			hBar->setRange( 0, h );
		}

		if (!haveVBar)
			hBar->setGeometry( 0, height()-SC_W, width(), SC_W );
		else
			hBar->setGeometry( 0, height()-SC_W, width()-SC_W, SC_W );

		hBar->show();

		haveHBar = true;
	}
	else if (haveHBar)
	{
		delete hBar;
		haveHBar = false;
	}




	if ( v > 0 )
	{

		if ( !haveVBar )
		{
			vBar = new QScrollBar( 0, v, 5, 20, 0, QScrollBar::Vertical,
				this, "VerticalScroll" );

			connect( vBar, SIGNAL(valueChanged(int)), SLOT(vScrolled(int)) );
		}
		else
		{
			vBar->setRange( 0, v );
		}

		if (!haveHBar)
			vBar->setGeometry( width()-SC_W, 0, SC_W, height() );
		else
			vBar->setGeometry( width()-SC_W, 0, SC_W, height()-SC_W );

		vBar->show();

		haveVBar = true;
	}
	else if (haveVBar)
	{
		delete vBar;
		haveVBar = false;
	}


	if( haveHBar && haveVBar )
	{
		dWid->setGeometry( width()-SC_W, height()-SC_W, SC_W, SC_W );

		dWid->show();
	}
	else
		dWid->hide();


}

void winedit::checkZoom()
{
int h = 0, v = 0;

	if ( win->width() +(2*BORDER) > width() )
		h = ( win->width() +(2*BORDER) -width() ) +SC_W;
	else if ( win->x() < BORDER )
		win->move( BORDER, win->y() );
	else if ( win->x() +win->width() > width()-BORDER )
		win->move( width() -BORDER -win->width(), win->y() );


	if ( win->height() +win->tHeight() +(2*BORDER) > height() )
		v = ( win->height() +win->tHeight() +(2*BORDER) - height() ) +SC_W;
	else if ( win->y() -win->tHeight() < BORDER )
		win->move( win->x(), BORDER +win->tHeight() );
	else if ( win->y() +win->height() > height() -BORDER )
		win->move( win->x(), height() -BORDER -win->height() );

	setScrollBars( h, v );

}


bool winedit::hasSWName( QWidget *par, QString tName, QWidget *exc )
{
int i;


	for( i = 0; i < MAX_SUBS; i++ )
	{
		if( swins[i] != 0L )
			if( swins[i]->getParent() == par && swins[i] != exc
				&& nameOf(swins[i]).lower() == tName.lower() )
					return true;

		if( sbut[i] != 0L )
			if( sbut[i]->getParent() == par && sbut[i] != exc
				&& nameOf(sbut[i]).lower() == tName.lower() )
					return true;

		if( slab[i] != 0L )
			if( slab[i]->getParent() == par && slab[i] != exc
				&& nameOf(slab[i]).lower() == tName.lower() )
					return true;

		if( splab[i] != 0L )
			if( splab[i]->getParent() == par && splab[i] != exc
				&& nameOf(splab[i]).lower() == tName.lower() )
					return true;

		if( sedi[i] != 0L )
			if( sedi[i]->getParent() == par && sedi[i] != exc
				&& nameOf(sedi[i]).lower() == tName.lower() )
					return true;

		if( slist[i] != 0L )
			if( slist[i]->getParent() == par && slist[i] != exc
				&& nameOf(slist[i]).lower() == tName.lower() )
					return true;

		if( schk[i] != 0L )
			if( schk[i]->getParent() == par && schk[i] != exc
				&& nameOf(schk[i]).lower() == tName.lower() )
					return true;

		if( sopt[i] != 0L )
			if( sopt[i]->getParent() == par && sopt[i] != exc
				&& nameOf(sopt[i]).lower() == tName.lower() )
					return true;

		if( shscr[i] != 0L )
			if( shscr[i]->getParent() == par && shscr[i] != exc
				&& nameOf(shscr[i]).lower() == tName.lower() )
					return true;

		if( spr[i] != 0L )
			if( spr[i]->getParent() == par && spr[i] != exc
				&& nameOf(spr[i]).lower() == tName.lower() )
					return true;


	} //for


	return false;

} //hasSWName(...)


void winedit::hScrolled(int h) //SLOT
{

	win->move( -h +BORDER, win->y() );
}


void winedit::vScrolled(int v) //SLOT
{

	win->move( win->x(), -v +BORDER +win->tHeight() );
}


void winedit::mr() //SLOT
{
	checkZoom();
}


void winedit::newWidget( int x1, int y1, int x2, int y2, widgetHolder *inW ) //SLOT
{
int i;

	modified = true;

	switch(tool)
	{
		case ID_WID:
			for( i = 0; swins[i] != 0L; i++ )
				if ( i == MAX_SUBS-1 )
					fatal ( "In winedit::newWidget(...): Too many sub windows #1." );

			swins[i] = new subWin( x1, y1, inW );
			swins[i]->resize( x2-x1, y2-y1 );

			swins[i]->show();
			swins[i]->setFocus();

			connect( swins[i], SIGNAL(resetTool()), SLOT(resetTool()) );

			connect( swins[i], SIGNAL(newWidget(int,int,int,int,widgetHolder *)),
				SLOT(newWidget(int,int,int,int,widgetHolder *)) );

			connect( swins[i], SIGNAL(modified()), SLOT(setModified()) );

			connect( swins[i], SIGNAL(deleteMe(widgetHolder*)),
				SLOT(deleteWid(widgetHolder*)) );

			connect( swins[i], SIGNAL(testName(QString,widgetHolder*)),
				SLOT(nameExists(QString,widgetHolder*)) );

			connect( swins[i], SIGNAL(showEvent(QString,QString)),
					SLOT(showEvt(QString,QString)) );

			swins[i]->forceNameCheck();

			break;

		case ID_BUTTON:

			for( i = 0; sbut[i] != 0L; i++ )
				if ( i == MAX_SUBS-1 )
					fatal ( "In winedit::newWidget(...): Too many sub windows #2." );

			sbut[i] = new subButton( x1, y1, inW );
			sbut[i]->resize( x2-x1, y2-y1 );

			sbut[i]->show();
			sbut[i]->setFocus();

			connect( sbut[i], SIGNAL(resetTool()), SLOT(resetTool()) );
			connect( sbut[i], SIGNAL(modified()), SLOT(setModified()) );

			connect( sbut[i], SIGNAL(deleteMe(widgetHolder*)),
				SLOT(deleteWid(widgetHolder*)) );

			connect( sbut[i], SIGNAL(testName(QString,widgetHolder*)),
				SLOT(nameExists(QString,widgetHolder*)) );

			connect( sbut[i], SIGNAL(showEvent(QString,QString)),
					SLOT(showEvt(QString,QString)) );

			sbut[i]->forceNameCheck();

			break;

		case ID_LABEL:
			for( i = 0; slab[i] != 0L; i++ )
				if ( i == MAX_SUBS-1 )
					fatal ( "In winedit::newWidget(...): Too many sub windows #3." );

			slab[i] = new subLabel( x1, y1, inW );
			slab[i]->resize( x2-x1, y2-y1 );

			slab[i]->show();
			slab[i]->setFocus();

			connect( slab[i], SIGNAL(resetTool()), SLOT(resetTool()) );
			connect( slab[i], SIGNAL(modified()), SLOT(setModified()) );

			connect( slab[i], SIGNAL(deleteMe(widgetHolder*)),
				SLOT(deleteWid(widgetHolder*)) );

			connect( slab[i], SIGNAL(testName(QString,widgetHolder*)),
				SLOT(nameExists(QString,widgetHolder*)) );

			connect( slab[i], SIGNAL(showEvent(QString,QString)),
					SLOT(showEvt(QString,QString)) );

			slab[i]->forceNameCheck();

			break;

		case ID_PIXLABEL:
			for( i = 0; splab[i] != 0L; i++ )
				if ( i == MAX_SUBS-1 )
					fatal ( "In winedit::newWidget(...): Too many sub windows #3." );

			splab[i] = new subPixLabel( x1, y1, inW );
			splab[i]->resize( x2-x1, y2-y1 );

			splab[i]->show();
			splab[i]->setFocus();

			connect( splab[i], SIGNAL(resetTool()), SLOT(resetTool()) );
			connect( splab[i], SIGNAL(modified()), SLOT(setModified()) );

			connect( splab[i], SIGNAL(deleteMe(widgetHolder*)),
				SLOT(deleteWid(widgetHolder*)) );

			connect( splab[i], SIGNAL(testName(QString,widgetHolder*)),
				SLOT(nameExists(QString,widgetHolder*)) );

			connect( splab[i], SIGNAL(showEvent(QString,QString)),
					SLOT(showEvt(QString,QString)) );

			splab[i]->forceNameCheck();

			break;

		case ID_EDITW:
			for( i = 0; sedi[i] != 0L; i++ )
				if ( i == MAX_SUBS-1 )
					fatal ( "In winedit::newWidget(...): Too many sub windows #4." );

			sedi[i] = new subEdit( x1, y1, inW );
			sedi[i]->resize( x2-x1, y2-y1 );

			sedi[i]->show();
			sedi[i]->setFocus();

			connect( sedi[i], SIGNAL(resetTool()), SLOT(resetTool()) );
			connect( sedi[i], SIGNAL(modified()), SLOT(setModified()) );

			connect( sedi[i], SIGNAL(deleteMe(widgetHolder*)),
				SLOT(deleteWid(widgetHolder*)) );

			connect( sedi[i], SIGNAL(testName(QString,widgetHolder*)),
				SLOT(nameExists(QString,widgetHolder*)) );

			connect( sedi[i], SIGNAL(showEvent(QString,QString)),
					SLOT(showEvt(QString,QString)) );

			sedi[i]->forceNameCheck();

			break;

		case ID_LIST:
			for( i = 0; slist[i] != 0L; i++ )
				if ( i == MAX_SUBS-1 )
					fatal ( "In winedit::newWidget(...): Too many sub windows #5." );

			slist[i] = new subList( x1, y1, inW );
			slist[i]->resize( x2-x1, y2-y1 );

			slist[i]->show();
			slist[i]->setFocus();

			connect( slist[i], SIGNAL(resetTool()), SLOT(resetTool()) );
			connect( slist[i], SIGNAL(modified()), SLOT(setModified()) );

			connect( slist[i], SIGNAL(deleteMe(widgetHolder*)),
				SLOT(deleteWid(widgetHolder*)) );

			connect( slist[i], SIGNAL(testName(QString,widgetHolder*)),
				SLOT(nameExists(QString,widgetHolder*)) );

			connect( slist[i], SIGNAL(showEvent(QString,QString)),
					SLOT(showEvt(QString,QString)) );

			slist[i]->forceNameCheck();

			break;

		case ID_CHECKW:
			for( i = 0; schk[i] != 0L; i++ )
				if ( i == MAX_SUBS-1 )
					fatal ( "In winedit::newWidget(...): Too many sub windows #6." );

			schk[i] = new subCheckBox( x1, y1, inW );
			schk[i]->resize( x2-x1, y2-y1 );

			schk[i]->show();
			schk[i]->setFocus();

			connect( schk[i], SIGNAL(resetTool()), SLOT(resetTool()) );
			connect( schk[i], SIGNAL(modified()), SLOT(setModified()) );

			connect( schk[i], SIGNAL(deleteMe(widgetHolder*)),
				SLOT(deleteWid(widgetHolder*)) );

			connect( schk[i], SIGNAL(testName(QString,widgetHolder*)),
				SLOT(nameExists(QString,widgetHolder*)) );

			connect( schk[i], SIGNAL(showEvent(QString,QString)),
					SLOT(showEvt(QString,QString)) );

			schk[i]->forceNameCheck();

			break;

		case ID_OPTIONW:
			for( i = 0; sopt[i] != 0L; i++ )
				if ( i == MAX_SUBS-1 )
					fatal ( "In winedit::newWidget(...): Too many sub windows #7." );

			sopt[i] = new subOptionButton( x1, y1, inW );
			sopt[i]->resize( x2-x1, y2-y1 );

			sopt[i]->show();
			sopt[i]->setFocus();

			connect( sopt[i], SIGNAL(resetTool()), SLOT(resetTool()) );
			connect( sopt[i], SIGNAL(modified()), SLOT(setModified()) );

			connect( sopt[i], SIGNAL(deleteMe(widgetHolder*)),
				SLOT(deleteWid(widgetHolder*)) );

			connect( sopt[i], SIGNAL(testName(QString,widgetHolder*)),
				SLOT(nameExists(QString,widgetHolder*)) );

			connect( sopt[i], SIGNAL(showEvent(QString,QString)),
					SLOT(showEvt(QString,QString)) );

			sopt[i]->forceNameCheck();

			connect( sopt[i], SIGNAL(eCheck(QWidget*,QWidget*)),
				SLOT(resetOptButtons(QWidget*,QWidget*)) );

			resetOptButtons( inW, sopt[i] );

			break;

		case ID_SLIDER:
			for( i = 0; shscr[i] != 0L; i++ )
				if ( i == MAX_SUBS-1 )
					fatal ( "In winedit::newWidget(...): Too many sub windows #8." );

			shscr[i] = new subSlider( x1, y1, inW );
			shscr[i]->resize( x2-x1, y2-y1 );

			shscr[i]->show();
			shscr[i]->setFocus();

			connect( shscr[i], SIGNAL(resetTool()), SLOT(resetTool()) );
			connect( shscr[i], SIGNAL(modified()), SLOT(setModified()) );

			connect( shscr[i], SIGNAL(deleteMe(widgetHolder*)),
				SLOT(deleteWid(widgetHolder*)) );

			connect( shscr[i], SIGNAL(testName(QString,widgetHolder*)),
				SLOT(nameExists(QString,widgetHolder*)) );

			connect( shscr[i], SIGNAL(showEvent(QString,QString)),
					SLOT(showEvt(QString,QString)) );

			shscr[i]->forceNameCheck();

			break;

		case ID_PROCCTRL:
			for( i = 0; spr[i] != 0L; i++ )
				if ( i == MAX_SUBS-1 )
					fatal ( "In winedit::newWidget(...): Too many sub windows #9." );

			spr[i] = new subProcCtrl( x1, y1, inW );
			spr[i]->resize( x2-x1, y2-y1 );

			spr[i]->show();
			spr[i]->setFocus();

			connect( spr[i], SIGNAL(resetTool()), SLOT(resetTool()) );
			connect( spr[i], SIGNAL(modified()), SLOT(setModified()) );

			connect( spr[i], SIGNAL(deleteMe(widgetHolder*)),
				SLOT(deleteWid(widgetHolder*)) );

			connect( spr[i], SIGNAL(testName(QString,widgetHolder*)),
				SLOT(nameExists(QString,widgetHolder*)) );

			connect( spr[i], SIGNAL(showEvent(QString,QString)),
					SLOT(showEvt(QString,QString)) );

			spr[i]->forceNameCheck();

			break;

		default:
			fatal ( "In winedit::newWidget(...): Unknown tool (Internal error)." );
	}

	actualI = i;

} //newWidget(...)


void winedit::resetTool() //SLOT
{
	setTool( ID_NO_TOOL );

	emit resetToolSignal();
}


void winedit::deleteWid( widgetHolder *delW ) //SLOT
{
int i;

	if ( KMsgBox::yesNo( 0L, "Deleting widget",
		QString ("Do you really want to delete this widget ?\n")
		+("There is no way to restore it.") ) != 1 ) return;


	for( i = 0; i < MAX_SUBS; i++ )
	{
		if( swins[i] == delW )
			if( swins[i]->getParent() == delW )
			{
				deleteWid( swins[i] );
				swins[i] = 0L;
			}

		if( sbut[i] == delW )
			if( sbut[i]->getParent() == delW )
			{
				deleteWid( sbut[i] );
				sbut[i] = 0L;
			}

		if( slab[i] == delW )
			if( slab[i]->getParent() == delW )
			{
				deleteWid( slab[i] );
				slab[i] = 0L;
			}

		if( splab[i] == delW )
			if( splab[i]->getParent() == delW )
			{
				deleteWid( splab[i] );
				splab[i] = 0L;
			}

		if( sedi[i] == delW )
			if( sedi[i]->getParent() == delW )
			{
				deleteWid( sedi[i] );
				sedi[i] = 0L;
			}

		if( slist[i] == delW )
			if( slist[i]->getParent() == delW )
			{
				deleteWid( slist[i] );
				slist[i] = 0L;
			}

		if( schk[i] == delW )
			if( schk[i]->getParent() == delW )
			{
				deleteWid( schk[i] );
				schk[i] = 0L;
			}

		if( sopt[i] == delW )
			if( sopt[i]->getParent() == delW )
			{
				deleteWid( sopt[i] );
				sopt[i] = 0L;
			}

		if( shscr[i] == delW )
			if( shscr[i]->getParent() == delW )
			{
				deleteWid( shscr[i] );
				shscr[i] = 0L;
			}

		if( spr[i] == delW )
			if( spr[i]->getParent() == delW )
			{
				deleteWid( spr[i] );
				spr[i] = 0L;
			}


	}


	for( i = 0; i < MAX_SUBS; i++ )
	{
		if( swins[i] == delW )
		{
			delete swins[i];
			swins[i] = 0L;
			break;
		}

		if( sbut[i] == delW )
		{
			delete sbut[i];
			sbut[i] = 0L;
			break;
		}

		if( slab[i] == delW )
		{
			delete slab[i];
			slab[i] = 0L;
			break;
		}

		if( splab[i] == delW )
		{
			delete splab[i];
			splab[i] = 0L;
			break;
		}

		if( sedi[i] == delW )
		{
			delete sedi[i];
			sedi[i] = 0L;
			break;
		}

		if( slist[i] == delW )
		{
			delete slist[i];
			slist[i] = 0L;
			break;
		}

		if( schk[i] == delW )
		{
			delete schk[i];
			schk[i] = 0L;
			break;
		}

		if( sopt[i] == delW )
		{
			delete sopt[i];
			sopt[i] = 0L;
			break;
		}

		if( shscr[i] == delW )
		{
			delete shscr[i];
			shscr[i] = 0L;
			break;
		}

		if( spr[i] == delW )
		{
			delete spr[i];
			spr[i] = 0L;
			break;
		}


	} //for

} //deleteWid(...)


void winedit::resetOptButtons( QWidget *rpar, QWidget *tg  ) //SLOT
{
int i;

	for( i = 0; i < MAX_SUBS; i++ )
	{

		if( sopt[i] != 0L )
			if ( sopt[i]->getParent() == rpar && sopt[i] != tg )
				sopt[i]->changeProperty( "CheckedExclusive", "FALSE" );
	}

}

void winedit::nameExists( QString tName, widgetHolder *twi ) //SLOT
{
	twi->setNResult( hasSWName( twi->getParent(), tName, twi ) );
}


void winedit::setModified() //SLOT
{
	modified = true;
}

void winedit::showEvt( QString dfn, QString cnt )
{
	emit showEvent( dfn, cnt );
}
