%{

/*************************************************************
*
* (c) 1999 Christoph Pinkel
* This is part of the VisKProg project.
*
* You may use it under the terms of the GPL licence.
* See COPYING for more details!
*
**************************************************************/

#undef yywrap

#include <stdio.h>
#include <string.h>

#include "pretrans.tab.h"

extern char *vkc, *in, *out;
extern int rlines;
int state = 0;

%}

FNAME		[a-zA-Z][a-zA-Z0-9]*
	/* Function or property name */

VARNAME		[a-zA-Z][a-zA-Z0-9_]*
	/* Variable/const name */

OBJNAME		([\.]?([a-zA-Z][a-zA-Z0-9]*\.)*[a-zA-Z][a-zA-Z0-9]*)|\.
	/* object name */


COMMENT		(([ \n\t]*"//"[^$]*$)|([ \n\t]*"/*"([^\*])*"*/"[ \n\t]*))
	/*Comments*/

SP		([ \n\t]|{COMMENT})+
	/* white-space */

BOOL		"TRUE"|"FALSE"
INT		[0-9]+
FLOAT		[0-9]*\.[0-9]+
STRING		[\"]("\\\""|[^\"])*[\"]

%option yylineno

%%

("Function"|"Event"){SP}{VARNAME}	{ yylval.str = strdup(yytext); return HEAD; }

{BOOL}		{ yylval.str = strdup(yytext); return CBOOL; }
{INT}		{ yylval.str = strdup(yytext); return CINT; }
{FLOAT}		{ yylval.str = strdup(yytext); return CFLOAT; }
{STRING}	{
		char *ret;
		int i;

			ret = (char *) malloc( 2*sizeof(char) );
			strcpy( ret, "\"" );

			for( i = 1; yytext[i] != 0L; i++ )
			{
				if( yytext[i] == '"' && yytext[i-1] == '\\' )
				{
					ret = realloc( ret, sizeof(char)
						*( strlen(ret) +4 ) );

					strcat( ret, "042" );
				}
				else
				{
					ret = realloc( ret, sizeof(char)
						*( strlen(ret) +2 ) );

					ret[ strlen(ret)+1 ] = 0L;
					ret[ strlen(ret) ] = yytext[i];
				}
			}

			yylval.str = strdup(ret);
			return CSTRING;
		}

"If"/({SP}*[\(]?{SP}*)		{ yylval.str = strdup(yytext); return IF; }
"Then"			{ yylval.str = strdup(yytext); return THEN; }
"Else"			{ yylval.str = strdup(yytext); return ELSE; }
"For"			{ yylval.str = strdup(yytext); return FOR; }
"To"			{ yylval.str = strdup(yytext); return TO; }
"Do"			{ yylval.str = strdup(yytext); return DO; }
"While"			{ yylval.str = strdup(yytext); return WHILE; }

{FNAME}/@		{ yylval.str = strdup(yytext); return PROPERTY; }

{FNAME}/({SP}*\()	{
				yylval.str = strdup(yytext);

				if( strxcmp(yytext, "if") == 0 ) /* if and while
						could also be followed by '(' */
					return IF;

				if( strxcmp(yytext, "while") == 0 )
					return WHILE;

				return FUNCTION;
			}

{FNAME}			{ yylval.str = strdup(yytext); return VARO; }

{VARNAME}		{ yylval.str = strdup(yytext); return VAR; }

{OBJNAME}		{

				yylval.str = strdup(yytext);

				return OBJECT;
			}

(\+)|(-)|(\*)|(\/)|(\^)|(%)|(&)	{ yylval.str = strdup(yytext); return OPERATOR; }
(==)|(<)|(>)|(<=)|(>=)|(\!=)	{ yylval.str = strdup(yytext); return OPERATOR; }

{SP}			;
.	return yytext[0];

%%

extern char *f_name;

yywrap()
{

	if( state == 0 )
	{
		printf( "Reading *.vk file now...\n" );
		rlines = yylineno;
		fclose(yyin);
		yyin = fopen( in, "r" );
		state = 1;
		f_name = in;
		yyparse();
		return;
	}
	else /* state == 1 ==> allready in 2nd (input) file */
		fclose(yyout);

}