/*************************************************************
*
* (c) 1999 Christoph Pinkel
* This is part of the VisKProg project.
*
* You may use it under the terms of the GPL licence.
* See COPYING for more details!
*
**************************************************************/

#ifndef CHILDLIST_H
#define CHILDLIST_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <qstring.h>

#include "vksubwidgets.h"

class childList //The class which manages the _dependent_ childs of vkWidgets
{
public:
	childList();

	bool setNew ( vkPushButton *, const char * );
	bool setNew ( vkLabel *, const char * );
	bool setNew ( vkPixLabel *, const char * );
	bool setNew ( vkLineEdit *, const char * );
	bool setNew ( vkListBox *, const char * );
	bool setNew ( vkCheckBox *, const char * );
	bool setNew ( vkOptionButton *, const char * );
	bool setNew ( vkSlider *, const char * );
	bool setNew ( vkProcCtrl *, const char * );

	void setCounter(int);

	void resetCounter(); // equivalent to setCounter(0);
	QString nextChildName();

	QString actualChildName();
	void changeChildName(QString);

	int childType(); /* 1: PushButton, 2: Label, 3: LineEdit, 4: ListBox,
				5: CheckBox, 6: OptionButton, 7: Slider,
				8: PixLabel, 9: ProcCtrl */
	int childId();


	vkPushButton *getButton();
	vkLabel *getLabel();
	vkPixLabel *getPLabel();
	vkLineEdit *getLineEdit();
	vkListBox *getListBox();
	vkCheckBox *getCheckBox();
	vkOptionButton *getOptionButton();
	vkSlider *getSlider();
	vkProcCtrl *getProc();

	void forgetChild();

	int maxIndex();

	#define button_array 0
	#define label_array 1
	#define lineedit_array 2
	#define listbox_array 3
	#define checkbox_array 4
	#define optionbutton_array 5
	#define slider_array 6
	#define pixlabel_array 7
	#define procctrl_array 8

private:
	int counter;

	vkPushButton *button[100];
	QString button_name[100];

	vkLabel *label[100];
	QString label_name[100];

	vkPixLabel *pixlabel[100];
	QString pixlabel_name[100];

	vkLineEdit *lineedit[100];
	QString lineedit_name[100];

	vkListBox *listbox[100];
	QString listbox_name[100];

	vkCheckBox *checkbox[100];
	QString checkbox_name[100];

	vkOptionButton *optionbutton[100];
	QString optionbutton_name[100];

	vkSlider *slider[100];
	QString slider_name[100];

	vkProcCtrl *procctrl[100];
	QString procctrl_name[100];

};

#endif //CHILDLIST_H
