/***************************************************************************
                          labelcomponent.cpp  -  description                              
                             -------------------                                         
    begin                : Fri Mar 19 1999                                           
    copyright            : (C) 1999 by Richard Moore                         
    email                : rich@kde.org                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/

#include <qlabel.h>

#include "labelcomponent.h"
#include "instance.h"

#include "intvalue.h"
#include "boolvalue.h"
#include "colourvalue.h"
#include "stringvalue.h"

#define COMPONENT_NAME "Label"
#define COMPONENT_DESC "A basic label widget"

LabelComponent::LabelComponent()
	: Component(COMPONENT_NAME, COMPONENT_DESC)
{
}

LabelComponent::~LabelComponent()
{
}

Instance *LabelComponent::createInstance(Instance *parent)
{
	warning("Creating Label Instance");

	Instance *i= new Instance(this, parent);

	i->addProperty("Background Colour", new ColourValue());
	i->addProperty("Enabled", new BoolValue());
	
	StringValue *sv= new StringValue();
	sv->fromString("Hello World!");
	i->addProperty("Text", sv);

	return i;
}

QWidget *LabelComponent::createView(Instance *props, QWidget *parent)
{
	ASSERT(parent);
	ASSERT(props);

	warning("Creating label view");
	
	QLabel *view= new QLabel(parent);
	CHECK_PTR(view);
		
	for (uint i= 0; i < props->childCount(); i++) {
		warning("++ Creating child %d", i);
		
		// Handle the top child
		Instance *child= props->getChild(i);
	
		// Recurse into the child's createView() method
		QWidget *childView= child->createView(view);
		
		if (!childView) {
			warning("Failed to create child %d", i);
		}
	}
	
	updateView(props, view);
		
	return view;
}

void LabelComponent::updateView(Instance *props, QWidget *view)
{
	ASSERT(view);
	ASSERT(props);
	
	if (view->inherits("QLabel")) {
		QLabel *l= (QLabel *) view;
		
		ColourValue *bg= (ColourValue *) props->get("Background Colour");
		l->setBackgroundColor(bg->color());
	
		BoolValue *en= (BoolValue *) props->get("Enabled");
		l->setEnabled(en->boolValue());

		StringValue *tx= (StringValue *) props->get("Text");
		l->setText(tx->toString());
		l->setMinimumSize(l->sizeHint());

		for (uint i= 0; i < props->childCount(); i++) {
			warning("++ Creating child %d", i);
		
			// Handle the top child
			Instance *child= props->getChild(i);
	
			// Recurse into the child's createView() method
			QWidget *childView= child->updateView(view);
			
			if (!childView) {
				warning("LabelComponent::updateView() received null childView");
			}
		}
	}	
}












































