/***************************************************************************
                          boolvalue.cpp  -  description                              
                             -------------------                                         
    begin                : Sat Apr 10 1999                                           
    copyright            : (C) 1999 by Richard Moore                         
    email                : rich@kde.org                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/

#include "boolvalueeditor.h"
#include "boolvalue.h"

BoolValue::BoolValue()
	: Value()
{
}

BoolValue::~BoolValue()
{
}

bool BoolValue::boolValue()
{
	return val;
}

void BoolValue::setValue(bool v)
{
	val= v;
}

ValueEditor *BoolValue::createEditor(QWidget *parent)
{
	ValueEditor *frame= new BoolValueEditor(parent, "Bool editor", this);
	CHECK_PTR(frame);

	return frame;
}

const char *BoolValue::toString()
{
	if (val) {
		valueStr= "True";
	}
	else {
		valueStr= "False";
	}
	return valueStr.data();
}

void BoolValue::fromString(const char *s)
{
	QString str(s);
	str.lower();
	
	warning("BoolValue fromString(%s)", str.data());
	if (str.find("true") != -1)
		val= true;
	else
		val= false;
}



