/*
 *   kwrl - a little VRML 2.0 editor
 *   Copyright (C) 1998,99  Mark R. Stevens
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

/* local headers */
#include <SFToken.h>
#include <Switch.h>
#include <TopLevel.h>

/*************************************************************************/
void Switch::eventIn(SFString &eventType, SFNode *eventData)
{

#ifdef DEBUG_EVENTS
  cout << "\nEntered Switch::eventIn (" << DEF << ")\n";
#endif 

    /* Determine what action to take based on incoming event */
  if ((eventType == "whichChoice") || (eventType == "set_whichChoice")) {
    SFInt32 *n = (SFInt32 *) eventData;
    whichChoice = *n;

  } else if ((eventType == "choice") || (eventType == "set_choice")) {
    Children *n = (Children *) eventData;
    choice = *n;

  }

}
/*************************************************************************/

/*************************************************************************/
void Switch::prepare(SFVec3f &, SFVec3f &)
{

#ifdef DEBUG_PREPARE
  cout << "\nEntered Switch::prepare (" << DEF << ")\n";
#endif 

}
/*************************************************************************/

/*************************************************************************/
void Switch::render(SFRenderInfo &SFRI)
{

#ifdef DEBUG_RENDER
  cout << "\nEntered Switch::render (" << DEF << ")\n";
#endif 

  /* if no node is requested do nothing */
  if (whichChoice == -1) return;

  /* get the choice */
  SFNode *n = choice[whichChoice];

  /* render the node */
  if (n != (SFNode *) 0) n->render(SFRI);

}
/*************************************************************************/

/*************************************************************************/
void Switch::parse(char *header, istream &InFile)
{

  /* we are valid */
  isValid() = true;

  /* a token in the file */
  SFToken Token;

  /* the required labels */
  bool TokenFound  = false;
  bool BeginBracketFound   = false;

  /* commence to search for the matching bracket */
  while (! InFile.eof()) {
    
    /* Remember where the token started from */
    Token.GetToken(InFile);

#ifdef DEBUG_PARSE
    cout << "\tSwitch: (" << Token() << ")\n";
#endif

    /* based on what token was found, continue parsing */
    if (Token == "DEF") {
      Token.GetToken(InFile);
      DEF = Token();

    } else if (Token == "USE") {
      Token.GetToken(InFile);
      USE = Token();
      unsatisfiedUSE() = true;
      return;

    } else if (Token == "whichChoice") {
      whichChoice.parse(header, InFile);

    } else if (Token == "choice") {
      choice.parse(header, InFile);

    } else if (Token == "Switch") {
      TokenFound = true;

    } else if (Token == "{") {
      BeginBracketFound = true;

    } else if (Token == "}") {
      break;

    } else {
      parseWarning(Token());

    }
  }

  /* if we did not find the material token we are in trouble */
  if (TokenFound == false) {
    cerr << "\nError:\n";
    cerr << "\tOccurred in (" << nodeType() << "::parse())\n";
    cerr << "\tDid not find expected identifier token.\n";
    exit(0);
  }
  if (BeginBracketFound == false) {
    cerr << "\nError:\n";
    cerr << "\tOccurred in (" << nodeType() << "::parse())\n";
    cerr << "\tDid not find expected \"{\" token.\n";
    exit(0);
  }
}
/*************************************************************************/
