/*
 *   kwrl - a little VRML 2.0 editor
 *   Copyright (C) 1998,99  Mark R. Stevens
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

/* local headers */
#include <SFToken.h>
#include <SFString.h>

/*************************************************************************/
void SFString::parse(char *, istream &InFile)
{

  /* we are valid */
  isValid() = true;

  /* Reset the string */
  *this = "\0";

  /* a token in the file */
  SFToken Token;
  
  /* read until a quote character is found */
  streampos p;
  do {
    p = Token.GetToken(InFile);
  } while (Token != "\"");

  /* continue to read and add characters until the other quote is
  ** found. We also need to make sure that the quote found does not
  ** have a backslash in front. */
  int num = 0;
  do {

    /* store the location before the end quote was found */
    Token.GetToken(InFile);
    
    /* append the string */
    if (Token != "\"") {
      if (num != 0) *this += " ";
      else          num += 1;
      *this += Token();
    }
    
  } while (Token != "\"");
  
#ifdef DEBUG_PARSE
  cout << "\tSFString: (" << data << ")\n";
#endif

}
/*************************************************************************/


