/*
 *   kwrl - a little VRML 2.0 editor
 *   Copyright (C) 1998,99  Mark R. Stevens
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

/* local headers */
#include <SFToken.h>
#include <MovieTexture.h>

/*************************************************************************/
void MovieTexture::prepare(SFVec3f &, SFVec3f &)
{

#ifdef DEBUG_PREPARE
  cout << "\nEntered MovieTexture::eventsIn (" << DEF << ")\n";
#endif 

  /* attempt to load the first url */
  if (! url.isValid()) {
    cerr << "\nError:\n";
    cerr << "\tOccurred in (" << nodeType() << "::operator >>)\n";
    cerr << "\tImage url not specified.\n";
    exit(0);
  } else {
  }

}
/*************************************************************************/

/*************************************************************************/
void MovieTexture::eventIn(SFString &eventType, SFNode *eventData)
{

#ifdef DEBUG_EVENTS
  cout << "\nEntered MovieTexture::eventsIn (" << DEF << ")\n";
#endif 

  /* Determine what action to take based on incoming event */
  if ((eventType == "url") || (eventType == "set_url")) {
    SFUrl *n = (SFUrl *) eventData;
    url = *n;;

  } else if ((eventType == "speed") || (eventType == "set_speed")) {
    SFFloat *n = (SFFloat *) eventData;
    speed = *n;;

  } else if ((eventType == "loop") || (eventType == "set_loop")) {
    SFBool *n = (SFBool *) eventData;
    loop = *n;

  } else if ((eventType == "startTime") || (eventType == "set_startTime")) {
    SFTime *n = (SFTime *) eventData;
    startTime = *n;;

  } else if ((eventType == "stopTime") || (eventType == "set_stopTime")) {
    SFTime *n = (SFTime *) eventData;
    stopTime = *n;;

  }

}
/*************************************************************************/

/*************************************************************************/
void MovieTexture::eventOut(SFString &, SFNode *)
{

#ifdef DEBUG_EVENTS
  cout << "\nEntered MovieTexture::eventsOut(" << DEF << ")\n";
#endif 

}
/*************************************************************************/

/*************************************************************************/
void MovieTexture::render(SFRenderInfo &)
{

#ifdef DEBUG_RENDER
  cout << "\nEntered MovieTexture::render (" << DEF << ")\n";
#endif 

}
/*************************************************************************/

/*************************************************************************/
void MovieTexture::parse(char *header, istream &InFile)
{

  /* we are valid */
  isValid() = true;
  
  /* a token in the file */
  SFToken Token;
  
  /* the required labels */
  char TokenFound  = false;
  char BeginBracketFound   = false;

  /* commence to search for the matching bracket */
  while (! InFile.eof()) {
    
    /* Remember where the token started from */
    Token.GetToken(InFile);

#ifdef DEBUG_PARSE
    cout << "\tMovieTexture: (" << Token() << ")\n";
#endif

    /* based on what token was found, continue parsing */
    if (Token == "DEF") {
      Token.GetToken(InFile);
      DEF = Token();

    } else if (Token == "USE") {
      Token.GetToken(InFile);
      USE = Token();
      unsatisfiedUSE() = true;
      return;

    } else if (Token ==  "repeatS") {
      repeatS.parse(header, InFile);

    } else if (Token ==  "repeatT") {
      repeatT.parse(header, InFile);

    } else if (Token ==  "speed") {
      speed.parse(header, InFile);

    } else if (Token ==  "loop") {
      loop.parse(header, InFile);

    } else if (Token ==  "startTime") {
      startTime.parse(header, InFile);

    } else if (Token ==  "stopTime") {
      stopTime.parse(header, InFile);

    } else if (Token == "url") {
      url.parse(header, InFile);

    } else if (Token == "MovieTexture") {
      TokenFound = true;

    } else if (Token == "{") {
      BeginBracketFound = true;

    } else if (Token == "}") {
      break;
      
    } else {
      parseWarning(Token());

    }
  }

  /* if we did not find the material token we are in trouble */
  if (TokenFound == false) {
    cerr << "\nError:\n";
    cerr << "\tOccurred in (" << nodeType() << "::parse())\n";
    cerr << "\tDid not find expected identifier token.\n";
    exit(0);
  }
  if (BeginBracketFound == false) {
    cerr << "\nError:\n";
    cerr << "\tOccurred in (" << nodeType() << "::parse())\n";
    cerr << "\tDid not find expected \"{\" token.\n";
    exit(0);
  }

}
/*************************************************************************/
