/*
 *   kwrl - a little VRML 2.0 editor
 *   Copyright (C) 1998,99  Mark R. Stevens
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

/* local headers */
#include <SFToken.h>
#include <Fog.h>

/*************************************************************************/
void Fog::eventIn(SFString &eventType, SFNode *eventData)
{

#ifdef DEBUG_EVENTS
  cout << "\nEntered Fog::eventsIn (" << DEF << ")\n";
#endif 

  /* Determine what action to take based on incoming event */
  if ((eventType == "fogType")    || (eventType == "set_fogType")) {
    SFString *n = (SFString *) eventData;
    fogType = *n;

  } else if ((eventType=="visibilityRange")||(eventType=="set_visibilityRange")) {
    SFFloat *n = (SFFloat *) eventData;
    visibilityRange = *n;

  } else if ((eventType == "color")    || (eventType == "set_color")) {
    SFColor *n = (SFColor *) eventData;
    color = *n;

  } else if (eventType == "set_bind") {
    SFBool *n = (SFBool *) eventData;
    isBound = *n;

  }
}
/*************************************************************************/

/*************************************************************************/
void Fog::eventOut(SFString &, SFNode *)
{

#ifdef DEBUG_EVENTS
  cout << "\nEntered Fog::eventsOut (" << DEF << ")\n";
#endif 

}
/*************************************************************************/

/*************************************************************************/
void Fog::render(SFRenderInfo &)
{

#ifdef DEBUG_RENDER
  cout << "\nEntered Extrusion::render (" << DEF << ")\n";
#endif 

  /* do nothing if not bound */
  if (isBound == false) return;

  /* set up the parameters */
  if (fogType == "EXPONENTIAL") glFogi(GL_FOG_MODE, GL_EXP);
  else                          glFogi(GL_FOG_MODE, GL_LINEAR);
  
  /* set the color */
  GLfloat c[4] = {color[0], color[1], color[2], 1.0};
  glFogfv (GL_FOG_COLOR, c);
  
  /* set the visibility range */
  glFogf (GL_FOG_END, visibilityRange);
  
  /* enable fog */
  glEnable(GL_FOG);

#ifdef DEBUG_RENDER
  cout << "\t" << gluErrorString(glGetError()) << "\n";  
#endif
  
}
/*************************************************************************/

/*************************************************************************/
void Fog::parse(char *header, istream &InFile)
{

  /* we are valid */
  isValid() = true;

  /* a token in the file */
  SFToken Token;

  /* the required labels */
  bool TokenFound  = false;
  bool BeginBracketFound   = false;

  /* commence to search for the matching bracket */
  while (! InFile.eof()) {
    
    /* Remember where the token started from */
    Token.GetToken(InFile);
    
#ifdef DEBUG_PARSE    
    cout << "\tFog: (" << Token() << ")\n";
#endif
    
    /* based on what token was found, continue parsing */
    if (Token == "DEF") {
      Token.GetToken(InFile);
      DEF = Token();

    } else if (Token == "USE") {
      Token.GetToken(InFile);
      USE = Token();
      unsatisfiedUSE() = true;
      return;

    } else if (Token == "fogType") {
      fogType.parse(header, InFile);
      
    } else if (Token == "visibilityRange") {
      visibilityRange.parse(header, InFile);

    } else if (Token == "color") {
      color.parse(header, InFile);

    } else if (Token == "Fog") {
      TokenFound = true;

    } else if (Token == "{") {
      BeginBracketFound = true;

    } else if (Token == "}") {
      break;
      
    } else {
      parseWarning(Token());

    }
  }

  /* if we did not find the material token we are in trouble */
  if (TokenFound == false) {
    cerr << "\nError:\n";
    cerr << "\tOccurred in (" << nodeType() << "::parse())\n";
    cerr << "\tDid not find expected identifier token.\n";
    exit(0);
  }
  if (BeginBracketFound == false) {
    cerr << "\nError:\n";
    cerr << "\tOccurred in (" << nodeType() << "::parse())\n";
    cerr << "\tDid not find expected \"{\" token.\n";
    exit(0);
  }
}
/*************************************************************************/
