/*
 *   kwrl - a little VRML 2.0 editor
 *   Copyright (C) 1998,99  Mark R. Stevens
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

/* local headers */
#include <SFToken.h>
#include <Box.h>

/*************************************************************************/
void Box::prepare(SFVec3f &min, SFVec3f &max)
{

#ifdef DEBUG_PREPARE
  cout << "\nEntered Box::prepare()\n";  
#endif

  /* get the modelview matrix */
  GLdouble m[16];
  glGetDoublev (GL_MODELVIEW_MATRIX,  m);

  /* local size coordinates */
  float ix = -size[0] / 2.0;
  float iy = -size[1] / 2.0;
  float iz = -size[2] / 2.0;

  /* get the first point */
  float ox = (m[0] * ix) + (m[4] * iy) + (m[8]  * iz) + m[12];
  float oy = (m[1] * ix) + (m[5] * iy) + (m[9]  * iz) + m[13];
  float oz = (m[2] * ix) + (m[6] * iy) + (m[10] * iz) + m[14];
  if (min[0] > ox) min[0] = ox;
  if (min[1] > oy) min[1] = oy;
  if (min[2] > oz) min[2] = oz;
  if (max[0] < ox) max[0] = ox;
  if (max[1] < oy) max[1] = oy;
  if (max[2] < oz) max[2] = oz;

  /* do the second point */
  ix *= -1.0;
  iy *= -1.0;
  iz *= -1.0;
  ox = (m[0] * ix) + (m[4] * iy) + (m[8]  * iz) + m[12];
  oy = (m[1] * ix) + (m[5] * iy) + (m[9]  * iz) + m[13];
  oz = (m[2] * ix) + (m[6] * iy) + (m[10] * iz) + m[14];
  if (min[0] > ox) min[0] = ox;
  if (min[1] > oy) min[1] = oy;
  if (min[2] > oz) min[2] = oz;
  if (max[0] < ox) max[0] = ox;
  if (max[1] < oy) max[1] = oy;
  if (max[2] < oz) max[2] = oz;

  /* local size coordinates */
  float X = size[0] / 2.0;
  float Y = size[1] / 2.0;
  float Z = size[2] / 2.0;

  /* create the call list */
  CallNum = glGenLists(1);
  glNewList(CallNum, GL_COMPILE_AND_EXECUTE);

  /* draw a bunch of four sided objects */
  glBegin(GL_QUADS);

  /* Front Face */
  glTexCoord2f(1.0, 0.0); glVertex3f(-X, -Y, -Z);
  glTexCoord2f(1.0, 1.0); glVertex3f(-X, +Y, -Z);
  glTexCoord2f(0.0, 1.0); glVertex3f(+X, +Y, -Z);
  glTexCoord2f(0.0, 0.0); glVertex3f(+X, -Y, -Z);

  /* Back Face */
  glTexCoord2f(1.0, 0.0); glVertex3f(+X, -Y, +Z);
  glTexCoord2f(1.0, 1.0); glVertex3f(+X, +Y, +Z);
  glTexCoord2f(0.0, 1.0); glVertex3f(-X, +Y, +Z);
  glTexCoord2f(0.0, 0.0); glVertex3f(-X, -Y, +Z);

  /* Left Face */
  glTexCoord2f(0.0, 0.0); glVertex3f(-X, -Y, -Z);
  glTexCoord2f(1.0, 0.0); glVertex3f(-X, -Y, +Z);
  glTexCoord2f(1.0, 1.0); glVertex3f(-X, +Y, +Z);
  glTexCoord2f(0.0, 1.0); glVertex3f(-X, +Y, -Z);

  /* Right Face */
  glTexCoord2f(1.0, 1.0); glVertex3f(+X, +Y, -Z);
  glTexCoord2f(0.0, 1.0); glVertex3f(+X, +Y, +Z);
  glTexCoord2f(0.0, 0.0); glVertex3f(+X, -Y, +Z);
  glTexCoord2f(1.0, 0.0); glVertex3f(+X, -Y, -Z);

  /* Top Face */
  glTexCoord2f(0.0, 1.0); glVertex3f(-X, +Y, -Z);
  glTexCoord2f(0.0, 0.0); glVertex3f(-X, +Y, +Z);
  glTexCoord2f(1.0, 0.0); glVertex3f(+X, +Y, +Z);
  glTexCoord2f(1.0, 1.0); glVertex3f(+X, +Y, -Z);

  /* Bottom Face */
  glTexCoord2f(1.0, 0.0); glVertex3f(+X, -Y, -Z);
  glTexCoord2f(1.0, 1.0); glVertex3f(+X, -Y, +Z);
  glTexCoord2f(0.0, 1.0); glVertex3f(-X, -Y, +Z);
  glTexCoord2f(0.0, 0.0); glVertex3f(-X, -Y, -Z);

  /* finish up drawing */
  glEnd();

  /* finish up the list */
  glEndList();

}
/*************************************************************************/

/*************************************************************************/
void Box::render(SFRenderInfo &)
{

#ifdef DEBUG_RENDER
  cout << "\nEntered Box::render()\n";  
#endif

  /* call the render function */
  glCallList(CallNum);

#ifdef DEBUG_RENDER
  cout << "\t" << gluErrorString(glGetError()) << "\n";  
#endif

}
/*************************************************************************/

/*************************************************************************/
void Box::parse(char *header, istream &InFile)
{

  /* we are valid */
  isValid() = true;

  /* a token in the file */
  SFToken Token;

  /* the required labels */
  char TokenFound  = false;
  char BeginBracketFound   = false;

  /* commence to search for the matching bracket */
  while (! InFile.eof()) {
    
    /* Remember where the token started from */
    Token.GetToken(InFile);
    
#ifdef DEBUG_PARSE    
    cout << "\tBox: (" << Token() << ")\n";
#endif
    
    /* based on what token was found, continue parsing */
    if (Token == "DEF") {
      Token.GetToken(InFile);
      DEF = Token();

    } else if (Token == "USE") {
      Token.GetToken(InFile);
      USE = Token();
      unsatisfiedUSE() = true;
      return;

    } else if (Token == "size") {
      size.parse(header, InFile);

    } else if (Token == "Box") {
      TokenFound = true;

    } else if (Token == "{") {
      BeginBracketFound = true;

    } else if (Token == "}") {
      break;
      
    } else {
      parseWarning(Token());

    }
  }

  /* if we did not find the material token we are in trouble */
  if (TokenFound == false) {
    cerr << "\nError:\n";
    cerr << "\tOccurred in (" << nodeType() << "::parse()\n";
    cerr << "\tDid not find expected identifier token.\n";
    exit(0);
  }
  if (BeginBracketFound == false) {
    cerr << "\nError:\n";
    cerr << "\tOccurred in (" << nodeType() << "::parse()\n";
    cerr << "\tDid not find expected \"{\" token.\n";
    exit(0);
  }
}
/*************************************************************************/
