/*
 *   kwrl - a little vrml viewer
 *   Copyright (C) 1996,97  Mark R. Stevens
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#ifdef HAVE_CONFIG_H
#   include <config.h>
#endif

#ifdef STDC_HEADERS
#   include <stdlib.h>
#   include <math.h>
#endif

/* c++ headers */
#include <iostream.h>

/* kde includes */
#include <kapp.h>

/* local includes */
#include "SFNode.h"
#include "VrmlViewer.h"
#include "VrmlParse.h"

#define DEBUG_MAIN_NOT

/*************************************************************************/
int main(int argc, char **argv) 
{

#ifdef DEBUG_MAIN
  cout << "\nEntered Main\n";
#endif

  /* start up the kde application */
  KApplication a(argc, argv, PACKAGE);  

#ifdef DEBUG_MAIN
  cout << "\tMain: Application Created\n";
#endif

  /* start up the viewer */
  VrmlViewer *vv = (VrmlViewer *) 0;

#ifdef DEBUG_MAIN
  cout << "\tMain: Viewer Createdn";
#endif

  /* show the arguments */
  if (argc > 1) vv = new VrmlViewer(argv[1]);
  else          vv = new VrmlViewer;

#ifdef DEBUG_MAIN
  cout << "\tMain: Viewer Initialized\n";
#endif
 
  /* associate that widget with the application. */
  a.setMainWidget(vv);

#ifdef DEBUG_MAIN
  cout << "\tMain: Main widget set\n";
#endif

  /* start up viewing */
  vv->show();

#ifdef DEBUG_MAIN
  cout << "\tMain: Viewing Started\n";
#endif

  /* run the application */
  return a.exec();

#ifdef DEBUG_MAIN
  cout << "\tMain: Done\n";
#endif

}
/*************************************************************************/
