/*
 *   kwrl - a little VRML 2.0 viewer
 *   Copyright (C) 1998,99  Mark R. Stevens
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#ifndef VIEWPOINT
#define VIEWPOINT

// label
#define ViewpointLabel "Viewpoint"

// classes
#include <SFNode.h>
#include <SFBool.h>
#include <SFFloat.h>
#include <SFString.h>
#include <SFRotation.h>
#include <SFVec3f.h>
#include <SFTime.h>

// class definition
class Viewpoint : public SFNode {

public:

  // constructor
  Viewpoint():SFNode(ViewpointLabel) {
    position[0]            =  0.0;
    position[1]            =  0.0;
    position[2]            = 10.0;
    orientation[0]         =  0.0;
    orientation[1]         =  0.0;
    orientation[2]         =  1.0;
    orientation[3]         =  0.0;
    fieldOfView            =  0.785398;
    jump                   =  true;
    isBound                =  false;
    bindTime               = -1.0;
    description            =  "Default";
  }

  // destructor
  ~Viewpoint() {
  }

  // parse
  void parse   (char         *, istream      &);

  // prepare
  void prepare (SFVec3f      &, SFVec3f      &);
    
  // render
  void render  (SFRenderInfo &);

  // events
  void eventIn (SFString     &, SFNode       *);
  void eventOut(SFString     &, SFNode       *);

  // operators
  Viewpoint &operator = (Viewpoint &V2) {
    position          = V2.position;
    orientation       = V2.orientation;
    fieldOfView       = V2.fieldOfView;
    description       = V2.description;
    jump              = V2.jump;
    isBound           = V2.isBound;
    bindTime          = V2.bindTime;
    isValid()         = V2.isValid();
    return(*this);
  }

  // USE-DEF
  SFNode *findDEF(SFString &UnsatUSE) {
    if (UnsatUSE == DEF) return(this);
    return((SFNode *) 0);
  }
  SFString *use() {
    return(&USE);
  }

 protected:

 private:

  // data 
  SFVec3f    position;
  SFRotation orientation;
  SFFloat    fieldOfView;
  SFString   description;
  SFBool     jump;

  // event data
  SFBool     isBound;
  SFTime     bindTime;

  // USE-DEF
  SFString   DEF;
  SFString   USE;

};

#endif // Viewpoint


