/*
 *   kwrl - a little VRML 2.0 viewer
 *   Copyright (C) 1998,99  Mark R. Stevens
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#ifndef TEXTURECOORDINATE
#define TEXTURECOORDINATE

// label
#define TextureCoordinateLabel "TextureCoordinate"

// classes
#include <SFNode.h>
#include <MFVec2f.h>
#include <SFString.h>

// class definition
class TextureCoordinate : public SFNode {

 public:

  // constructor
  TextureCoordinate() : SFNode(TextureCoordinateLabel) {
  }
  
  // destructor
  ~TextureCoordinate() {
  }

  // parse
  void parse   (char     *, istream  &);

  // events
  void eventIn (SFString &, SFNode   *);

  // operators
  TextureCoordinate &operator = (TextureCoordinate &T2) {
    point                     = T2.point;
    isValid()                 = T2.isValid();
    return(*this);
  }
  SFVec2f  & operator [] (int i) {
    return(point[i]);
  }
  int num() {
    return(point.num());
  }

  // USE-DEF
  SFNode *findDEF(SFString &UnsatUSE) {
    if (UnsatUSE == DEF) return(this);
    return((SFNode *) 0);
  }
  SFString *use() {
    return(&USE);
  }

 protected:

 private:

  //  the data
  MFVec2f point;

  // USE-DEF
  SFString DEF;
  SFString USE;

};

#endif // TextureCoordinate




