/*
 *   kwrl - a little VRML 2.0 viewer
 *   Copyright (C) 1998,99  Mark R. Stevens
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */


#ifndef SPHERESENSOR
#define SPHERESENSOR

// label
#define SphereSensorLabel "SphereSensor"

// classes
#include <SFNode.h>
#include <SFBool.h>
#include <SFRotation.h>
#include <SFVec3f.h>
#include <SFString.h>

// class definition
class SphereSensor : public SFNode {

 public:

  // constructor
  SphereSensor() : SFNode(SphereSensorLabel) {
    enabled               = true;
    isActive              = false;
    autoOffset            = true;
    offset[0]             = 0.0;
    offset[1]             = 1.0;
    offset[2]             = 0.0;
    offset[3]             = 0.0;
  }
    
  // destructor
  ~SphereSensor() {
  }

  // parse
  void parse   (char *, istream  &);

  // events
  void eventIn (SFString &, SFNode *);
  void eventOut(SFString &, SFNode *);

  // operators
  SphereSensor &operator  = (SphereSensor &S2) {
    enabled               = S2.enabled;
    offset                = S2.offset;
    autoOffset            = S2.autoOffset;
    isActive              = S2.isActive;
    trackPoint_changed    = S2.trackPoint_changed;
    rotation_changed      = S2.rotation_changed;
    isValid()             = S2.isValid();
    return(*this);
  }

  // USE-DEF
  SFNode *findDEF(SFString &UnsatUSE) {
    if (UnsatUSE == DEF) return(this);
    return((SFNode *) 0);
  }
  SFString *use() {
    return(&USE);
  }

 protected:

 private:

  // data
  SFBool     enabled;
  SFRotation offset;
  SFBool     autoOffset;

  // event data
  SFBool     isActive;
  SFVec3f    trackPoint_changed;
  SFVec3f    rotation_changed;

  // USE-DEF
  SFString   DEF;
  SFString   USE;

};

#endif // SphereSensor








